/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.configs;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.configs.Config;
import de.murmelmeister.lobby.util.FileUtil;
import de.murmelmeister.lobby.util.HexColor;
import de.murmelmeister.lobby.util.config.Configs;
import de.murmelmeister.lobby.util.config.Messages;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Message {
    private final Logger logger;
    private final Config defaultConfig;
    private File file;
    private YamlConfiguration config;

    public Message(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
    }

    public void register() {
        this.create();
        this.load();
        this.save();
    }

    public void create() {
        String fileName = "message.yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void load() {
        for (Messages messages : Messages.values()) {
            if (this.getString(messages) != null) continue;
            this.set(messages);
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Messages messages) {
        this.config.set(messages.getPath(), (Object)messages.getValue());
    }

    public String getString(Messages messages) {
        return this.config.getString(HexColor.format(messages.getPath()));
    }

    public String prefix() {
        return this.getString(Messages.PREFIX);
    }
}

