/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.command.commands;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.command.CommandManager;
import de.murmelmeister.lobby.util.config.Configs;
import de.murmelmeister.lobby.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnHeightCommand
extends CommandManager {
    public SpawnHeightCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SPAWN_HEIGHT)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SPAWN_HEIGHT)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (!this.locations.isSpawnHeightExist()) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_EXIST_SPAWN_HEIGHT));
            return true;
        }
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GET_SPAWN_HEIGHT).replace("[HEIGHT]", String.valueOf(player.getLocation().getBlockY())));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

