/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.listener.listeners;

import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.listener.Listeners;
import de.murmelmeister.lobby.util.HexColor;
import de.murmelmeister.lobby.util.Items;
import de.murmelmeister.lobby.util.config.Configs;
import de.murmelmeister.lobby.util.config.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ConnectListener
extends Listeners {
    public ConnectListener(Main main) {
        super(main);
    }

    @EventHandler
    public void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_JOIN)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.setJoinMessage(HexColor.format(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName())));
                } else {
                    event.setJoinMessage(HexColor.format(this.message.getString(Messages.EVENT_PLAYER_JOIN).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.setJoinMessage(null);
            }
        } else {
            event.setJoinMessage(null);
        }
        if (this.locations.isSpawnExist()) {
            if (this.config.getBoolean(Configs.EVENT_ENABLE_TELEPORT_TO_SPAWN)) {
                player.teleport(this.locations.getSpawn());
            }
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.EVENT_SPAWN_NOT_EXIST).replace("[PREFIX]", this.message.prefix()));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_MESSAGE)) {
            player.sendMessage(HexColor.format(this.message.getString(Messages.EVENT_JOIN_MESSAGE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())));
        }
        if (this.config.getBoolean(Configs.EVENT_ENABLE_JOIN_TITLE)) {
            player.sendTitle(HexColor.format(this.message.getString(Messages.EVENT_JOIN_TITLE)).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName()), HexColor.format(this.message.getString(Messages.EVENT_JOIN_SUB_TITLE).replace("[PREFIX]", this.message.prefix()).replace("[PLAYER]", player.getName())));
        }
        Items.setLobbyItems(this.config, player);
    }

    @EventHandler
    public void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.config.getBoolean(Configs.EVENT_ENABLE_PLAYER_QUIT)) {
            if (player.canSee(player)) {
                if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
                    event.setQuitMessage(HexColor.format(this.message.prefix() + this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName())));
                } else {
                    event.setQuitMessage(HexColor.format(this.message.getString(Messages.EVENT_PLAYER_QUIT).replace("[PLAYER]", player.getName())));
                }
            } else {
                event.setQuitMessage(null);
            }
        } else {
            event.setQuitMessage(null);
        }
        this.listUtil.getBuild().remove(player.getUniqueId());
    }
}

