/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.lobby.listener;

import de.murmelmeister.lobby.Lobby;
import de.murmelmeister.lobby.Main;
import de.murmelmeister.lobby.api.Locations;
import de.murmelmeister.lobby.configs.Config;
import de.murmelmeister.lobby.configs.Message;
import de.murmelmeister.lobby.listener.listeners.ConnectListener;
import de.murmelmeister.lobby.listener.listeners.LobbyItemsListener;
import de.murmelmeister.lobby.listener.listeners.OtherListener;
import de.murmelmeister.lobby.listener.listeners.RespawnListener;
import de.murmelmeister.lobby.util.HexColor;
import de.murmelmeister.lobby.util.ListUtil;
import de.murmelmeister.lobby.util.config.Configs;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Listeners
implements Listener {
    public final Main main;
    public final Lobby instance;
    public final ListUtil listUtil;
    public final Locations locations;
    public final Config config;
    public final Message message;

    public Listeners(Main main) {
        this.main = main;
        this.instance = main.getInstance();
        this.listUtil = main.getListUtil();
        this.config = main.getConfig();
        this.message = main.getMessage();
        this.locations = main.getLocations();
    }

    public void register() {
        this.addListener(new OtherListener(this.main));
        this.addListener(new LobbyItemsListener(this.main));
        this.addListener(new ConnectListener(this.main));
        this.addListener(new RespawnListener(this.main));
    }

    private void addListener(Listener listener) {
        this.instance.getServer().getPluginManager().registerEvents(listener, (Plugin)this.instance);
    }

    public void sendMessage(CommandSender sender, String message) {
        if (this.config.getBoolean(Configs.PREFIX_ENABLE)) {
            sender.sendMessage(HexColor.format(this.message.prefix() + message));
        } else {
            sender.sendMessage(HexColor.format(message));
        }
    }
}

