/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils.update;

import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public final class RefreshUtil {
    private static final CopyOnWriteArrayList<RefreshListener> LISTENERS = new CopyOnWriteArrayList();
    private static final Set<RefreshEvent<?>> RECENT = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ScheduledExecutorService DEBOUNCER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "RefreshDebouncer");
        thread.setDaemon(true);
        return thread;
    });

    public static void register(RefreshListener listener) {
        LISTENERS.add(listener);
    }

    public static void unregister(RefreshListener listener) {
        LISTENERS.remove(listener);
    }

    public static <K> void fire(RefreshEvent<K> event) {
        if (!RECENT.add(event)) {
            return;
        }
        DEBOUNCER.schedule(() -> RECENT.remove(event), 100L, TimeUnit.MILLISECONDS);
        for (RefreshListener listener : LISTENERS) {
            try {
                listener.onRefresh(event);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RefreshListener.class).error("Listener {} failed to handle refresh event: {}", new Object[]{listener, event, e});
            }
        }
    }

    public static <K> void fireSingle(String cacheName, K key) {
        RefreshUtil.fire(new RefreshEvent<K>(cacheName, key));
    }

    public static <K> void fireSingle(RefreshType type, K key) {
        RefreshUtil.fire(new RefreshEvent<K>(type, key));
    }

    public static void fireCache(String cacheName) {
        RefreshUtil.fire(new RefreshEvent<Object>(cacheName, null));
    }

    public static void fireCache(RefreshType type) {
        RefreshUtil.fire(new RefreshEvent<Object>(type, null));
    }

    public static void fireAll() {
        RefreshUtil.fire(new RefreshEvent<Object>(RefreshType.ALL, null));
    }
}

