/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.permission;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.permission.UserPermission;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserPermissionCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private static final Pattern KEY_PATTERN = Pattern.compile(".*userId=(\\d+), permission=([^,\\]]+).*");
    private final Database database;
    private final String tableName;
    private final LoadingCache<PermissionKey, UserPermission> cacheByKey;
    private final LoadingCache<Integer, List<UserPermission>> cacheByUserId;
    private final LoadingCache<String, List<UserPermission>> listCache;
    private final Long fetchLimit;

    public UserPermissionCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheByKey = CacheUtil.buildCacheRefresh(this::loadByKey, cacheCapcity, refreshInterval);
        this.cacheByUserId = CacheUtil.buildCacheRefresh(this::loadByUserId, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_PERMISSIONS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER_PERMISSION.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof PermissionKey) {
                    PermissionKey permissionKey = (PermissionKey)key;
                    this.refreshSingle(permissionKey);
                } else if (key instanceof Integer) {
                    Integer userId = (Integer)key;
                    this.refreshSingle(userId);
                }
            } else {
                Matcher matcher = KEY_PATTERN.matcher((String)key);
                if (matcher.matches()) {
                    int userId = Integer.parseInt(matcher.group(1));
                    String permission = matcher.group(2);
                    this.refreshSingle(new PermissionKey(userId, permission));
                } else {
                    int userId = Integer.parseInt((String)key);
                    this.refreshSingle(userId);
                }
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<UserPermission> permissions = this.loadAllFromDatabase();
        if (permissions.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byUser = new HashMap<Integer, List>();
        for (UserPermission permission : permissions) {
            PermissionKey key = new PermissionKey(permission.userId(), permission.permission());
            this.cacheByKey.put((Object)key, (Object)permission);
            byUser.computeIfAbsent(permission.userId(), ignored -> new ArrayList()).add(permission);
        }
        byUser.forEach((userId, values) -> this.cacheByUserId.put(userId, List.copyOf(values)));
        this.listCache.put((Object)ALL_KEY, List.copyOf(permissions));
    }

    private void refreshSingle(int userId) {
        this.remove(userId);
        List<UserPermission> permissions = this.loadByUserId(userId);
        permissions.forEach(this::put);
    }

    private void refreshSingle(PermissionKey key) {
        this.remove(key.userId(), key.permission());
        UserPermission permission = this.loadByKey(key);
        if (permission != null) {
            this.put(permission);
        }
    }

    private List<UserPermission> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userPermission());
    }

    private List<UserPermission> loadByUserId(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userPermission(), stmt -> stmt.setInt(1, userId));
    }

    private UserPermission loadByKey(PermissionKey key) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ? AND permission = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userPermission(), stmt -> {
            stmt.setInt(1, key.userId());
            stmt.setString(2, key.permission());
        });
    }

    public UserPermission get(int userId, String permission) {
        return (UserPermission)this.cacheByKey.get((Object)new PermissionKey(userId, permission));
    }

    public List<UserPermission> getPermissions(int userId) {
        return (List)this.cacheByUserId.get((Object)userId);
    }

    public void put(UserPermission permission) {
        PermissionKey key = new PermissionKey(permission.userId(), permission.permission());
        this.cacheByKey.put((Object)key, (Object)permission);
        CacheUtil.put(this.cacheByUserId, permission.userId(), permission, v -> v.userId() == permission.userId() && v.permission().equals(permission.permission()));
        CacheUtil.put(this.listCache, ALL_KEY, permission, v -> v.userId() == permission.userId() && v.permission().equals(permission.permission()));
    }

    public void remove(int userId, String permission) {
        PermissionKey key = new PermissionKey(userId, permission);
        this.cacheByKey.invalidate((Object)key);
        CacheUtil.remove(this.cacheByUserId, userId, v -> v.userId() == userId && v.permission().equals(permission));
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.userId() == userId && v.permission().equals(permission));
    }

    public void remove(int userId) {
        this.cacheByKey.asMap().keySet().stream().filter(key -> key.userId() == userId).forEach(arg_0 -> this.cacheByKey.invalidate(arg_0));
        this.cacheByUserId.invalidate((Object)userId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.userId() == userId);
    }

    public void clear() {
        this.cacheByKey.invalidateAll();
        this.cacheByUserId.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<UserPermission> getCachedPermissions() {
        List permissions = (List)this.listCache.get((Object)ALL_KEY);
        if (permissions == null || permissions.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(permissions);
    }

    protected record PermissionKey(int userId, String permission) {
    }
}

