/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.parent;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.parent.UserParent;
import de.murmelmeister.murmelapi.user.parent.UserParentCache;
import de.murmelmeister.murmelapi.user.parent.UserParentProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public final class UserParentProviderImpl
implements UserParentProvider {
    private static final String TABLE_NAME = "user_parent";
    private final Database database;
    private final UserParentCache cache;
    private final RefreshType all = RefreshType.USER_PARENTS;
    private final RefreshType single = RefreshType.SINGLE_USER_PARENT;

    public UserParentProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new UserParentCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "user_id INT, parent_id INT, PRIMARY KEY (user_id, parent_id), expires_at DATETIME NULL, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), changed_by INT NULL, changed_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP(), FOREIGN KEY (user_id) REFERENCES users(id), FOREIGN KEY (parent_id) REFERENCES groups(id),FOREIGN KEY (created_by) REFERENCES users(id), FOREIGN KEY (changed_by) REFERENCES users(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_user_parent_userId_exp ON user_parent (user_id, expires_at)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public UserParent getParent(int userId, int parentId) {
        return this.cache.get(userId, parentId);
    }

    @Override
    public List<UserParent> getParents(int userId) {
        return this.cache.getParents(userId);
    }

    @Override
    public UserParent add(int userId, int parentId, long duration, int createdBy) {
        if (userId < 1 || parentId < 1 || duration < -1L || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO user_parent (user_id, parent_id, expires_at, created_by) VALUES (?, ?, ?, ?)";
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        int row = this.database.update(insertSql, stmt -> {
            stmt.setInt(1, userId);
            stmt.setInt(2, parentId);
            stmt.setTimestamp(3, expiresAt == null ? null : Timestamp.valueOf(expiresAt));
            stmt.setInt(4, createdBy);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM user_parent WHERE user_id = ? AND parent_id = ?";
        LocalDateTime createdAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, userId);
            stmt.setInt(2, parentId);
        });
        if (createdAt == null) {
            return null;
        }
        UserParent userParent = new UserParent(userId, parentId, expiresAt, createdBy, createdAt, null, null);
        RefreshUtil.fireSingle(this.single, new UserParentCache.ParentKey(userId, parentId));
        return userParent;
    }

    @Override
    public int remove(int userId, int parentId) {
        if (userId < 1 || parentId < 1) {
            return 0;
        }
        String sql = "DELETE FROM user_parent WHERE user_id = ? AND parent_id = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setInt(1, userId);
            stmt.setInt(2, parentId);
        });
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, new UserParentCache.ParentKey(userId, parentId));
        return row;
    }

    @Override
    public int clear(int userId) {
        if (userId < 1) {
            return 0;
        }
        String sql = "DELETE FROM user_parent WHERE user_id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, userId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return row;
    }

    @Override
    public UserParent update(int userId, int parentId, long duration, int changedBy) {
        if (userId < 1 || parentId < 1 || duration < -1L || changedBy < -1) {
            return null;
        }
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        UserParent existing = this.cache.get(userId, parentId);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(expiresAt, existing.expiresAt())) {
            return existing;
        }
        String updateSql = "UPDATE user_parent SET expires_at = ?, changed_by = ? WHERE user_id = ? AND parent_id = ?";
        int row = this.database.update(updateSql, stmt -> {
            stmt.setTimestamp(1, expiresAt == null ? null : Timestamp.valueOf(expiresAt));
            stmt.setInt(2, changedBy);
            stmt.setInt(3, userId);
            stmt.setInt(4, parentId);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT changed_at FROM user_parent WHERE user_id = ? AND parent_id = ?";
        LocalDateTime changedAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("changed_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, userId);
            stmt.setInt(2, parentId);
        });
        if (changedAt == null) {
            return null;
        }
        UserParent userParent = existing.withUpdateMeta(expiresAt, changedBy, changedAt);
        RefreshUtil.fireSingle(this.single, new UserParentCache.ParentKey(userId, parentId));
        return userParent;
    }

    @Override
    public int loadExpired() {
        List<UserParentCache.ParentKey> expiredParents = this.cache.getCachedParents().stream().filter(UserParent::isExpired).map(parent -> new UserParentCache.ParentKey(parent.userId(), parent.parentId())).toList();
        if (expiredParents.isEmpty()) {
            return 0;
        }
        String sql = "DELETE FROM user_parent WHERE expires_at IS NOT NULL AND expires_at <= CURRENT_TIMESTAMP()";
        int removed = this.database.update(sql);
        expiredParents.forEach(key -> RefreshUtil.fireSingle(this.single, key));
        return removed;
    }
}

