/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.login;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.login.UserLogin;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class UserLoginCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<UUID, UserLogin> cacheById;
    private final LoadingCache<Integer, List<UserLogin>> cacheByUserId;
    private final LoadingCache<String, List<UserLogin>> cacheByIpAddress;
    private final LoadingCache<String, List<UserLogin>> listCache;
    private final Long fetchLimit;

    public UserLoginCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapcity, refreshInterval);
        this.cacheByUserId = CacheUtil.buildCacheRefresh(this::loadByUserId, cacheCapcity, refreshInterval);
        this.cacheByIpAddress = CacheUtil.buildCacheRefresh(this::loadByIpAddress, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_LOGINS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER_LOGIN.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof UUID) {
                    UUID sessionId = (UUID)key;
                    this.refreshSingle(sessionId);
                }
            } else {
                UUID sessionId = UUID.fromString((String)key);
                this.refreshSingle(sessionId);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<UserLogin> userLogins = this.loadAllFromDatabase();
        if (userLogins.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byUser = new HashMap<Integer, List>();
        HashMap<String, List> byIpAddress = new HashMap<String, List>();
        for (UserLogin userLogin : userLogins) {
            this.cacheById.put((Object)userLogin.id(), (Object)userLogin);
            byUser.computeIfAbsent(userLogin.userId(), ignored -> new ArrayList()).add(userLogin);
            byIpAddress.computeIfAbsent(userLogin.ipAddress(), ignored -> new ArrayList()).add(userLogin);
        }
        byUser.forEach((userId, logins) -> this.cacheByUserId.put(userId, List.copyOf(logins)));
        byIpAddress.forEach((ip, logins) -> this.cacheByIpAddress.put(ip, List.copyOf(logins)));
        this.listCache.put((Object)ALL_KEY, List.copyOf(userLogins));
    }

    private void refreshSingle(UUID sessionId) {
        this.remove(sessionId);
        UserLogin userLogin = this.loadById(sessionId);
        if (userLogin != null) {
            this.put(userLogin);
        }
    }

    private List<UserLogin> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userLogin());
    }

    private List<UserLogin> loadByUserId(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userLogin(), stmt -> stmt.setInt(1, userId));
    }

    private List<UserLogin> loadByIpAddress(String ipAddress) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE ip_address = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userLogin(), stmt -> stmt.setString(1, ipAddress));
    }

    private UserLogin loadById(UUID id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userLogin(), stmt -> stmt.setString(1, id.toString()));
    }

    public UserLogin getById(UUID id) {
        return (UserLogin)this.cacheById.get((Object)id);
    }

    public List<UserLogin> getByUserId(int userId) {
        return (List)this.cacheByUserId.get((Object)userId);
    }

    public List<UserLogin> getByIpAddress(String ipAddress) {
        return (List)this.cacheByIpAddress.get((Object)ipAddress);
    }

    public void put(UserLogin userLogin) {
        this.cacheById.put((Object)userLogin.id(), (Object)userLogin);
        CacheUtil.put(this.cacheByUserId, userLogin.userId(), userLogin, v -> v.id().equals(userLogin.id()));
        CacheUtil.put(this.cacheByIpAddress, userLogin.ipAddress(), userLogin, v -> v.id().equals(userLogin.id()));
        CacheUtil.put(this.listCache, ALL_KEY, userLogin, v -> v.id().equals(userLogin.id()));
    }

    public void remove(UUID id) {
        UserLogin userLogin = (UserLogin)this.cacheById.getIfPresent((Object)id);
        this.cacheById.invalidate((Object)id);
        if (userLogin != null) {
            CacheUtil.remove(this.cacheByUserId, userLogin.userId(), v -> v.id().equals(id));
            CacheUtil.remove(this.cacheByIpAddress, userLogin.ipAddress(), v -> v.id().equals(id));
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id().equals(id));
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByUserId.invalidateAll();
        this.cacheByIpAddress.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<UserLogin> getCachedLogins() {
        List logins = (List)this.listCache.get((Object)ALL_KEY);
        if (logins == null || logins.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(logins);
    }
}

