/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class UserCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<Integer, User> cacheById;
    private final LoadingCache<UUID, User> cacheByUUID;
    private final LoadingCache<String, User> cacheByName;
    private final LoadingCache<String, List<User>> listCache;
    private final Long fetchLimit;

    public UserCache(Database database, String tableName, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapacity, refreshInterval);
        this.cacheByUUID = CacheUtil.buildCacheRefresh(this::loadByUUID, cacheCapacity, refreshInterval);
        this.cacheByName = CacheUtil.buildCacheRefresh(this::loadByName, cacheCapacity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USERS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            Integer id = null;
            if (key instanceof Number) {
                Number number = (Number)key;
                id = number.intValue();
            } else if (key instanceof String) {
                String stringKey = (String)key;
                try {
                    id = Integer.parseInt(stringKey);
                }
                catch (NumberFormatException ignored) {
                    return;
                }
            }
            if (id != null) {
                this.refreshSingle(id);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<User> users = this.loadAllFromDatabase();
        if (users.isEmpty()) {
            return;
        }
        users.forEach(user -> {
            this.cacheById.put((Object)user.id(), user);
            this.cacheByUUID.put((Object)user.mojangId(), user);
            this.cacheByName.put((Object)user.username(), user);
        });
        this.listCache.put((Object)ALL_KEY, List.copyOf(users));
    }

    private void refreshSingle(int id) {
        this.remove(id);
        User user = this.loadById(id);
        if (user != null) {
            this.put(user);
        }
    }

    private List<User> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.user());
    }

    private User loadByName(String name) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE username = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.user(), stmt -> stmt.setString(1, name));
    }

    private User loadByUUID(UUID uuid) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE mojang_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.user(), stmt -> stmt.setString(1, uuid.toString()));
    }

    private User loadById(int id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.user(), stmt -> stmt.setInt(1, id));
    }

    public User getById(int id) {
        return (User)this.cacheById.get((Object)id);
    }

    public User getByUUID(UUID uuid) {
        return (User)this.cacheByUUID.get((Object)uuid);
    }

    public User getByName(String name) {
        return (User)this.cacheByName.get((Object)name);
    }

    public void put(User user) {
        this.cacheById.put((Object)user.id(), (Object)user);
        this.cacheByUUID.put((Object)user.mojangId(), (Object)user);
        this.cacheByName.put((Object)user.username(), (Object)user);
        CacheUtil.put(this.listCache, ALL_KEY, user, v -> v.id() == user.id());
    }

    public void remove(int id) {
        User user = (User)this.cacheById.getIfPresent((Object)id);
        if (user != null) {
            this.cacheById.invalidate((Object)id);
            this.cacheByUUID.invalidate((Object)user.mojangId());
            this.cacheByName.invalidate((Object)user.username());
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id() == id);
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByUUID.invalidateAll();
        this.cacheByName.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<User> getCachedUsers() {
        List users = (List)this.listCache.get((Object)ALL_KEY);
        if (users == null || users.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(users);
    }
}

