/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.settings;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.settings.Settings;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.MurmelCache;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SettingsCache
implements MurmelCache {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<@NotNull String, Settings> cache;
    private final LoadingCache<@NotNull String, List<Settings>> listCache;
    private final Long fetchLimit;

    public SettingsCache(Database database, String tableName, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cache = CacheUtil.buildCacheRefresh(this::loadSingleFromDatabase, cacheCapacity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), cacheCapacity, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        Object key;
        String cacheName = event.type();
        if (RefreshType.SETTINGS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_SETTING.getName().equalsIgnoreCase(cacheName) && (key = event.key()) instanceof String) {
            String tagId = (String)key;
            this.refreshSingle(tagId);
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    public void refreshAll() {
        this.clear();
        List<Settings> settings = this.loadAllFromDatabase();
        if (settings.isEmpty()) {
            return;
        }
        settings.forEach(this::put);
    }

    public void refreshSingle(String tagId) {
        this.remove(tagId);
        Settings settings = this.loadSingleFromDatabase(tagId);
        if (settings != null) {
            this.put(settings);
        }
    }

    private List<Settings> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.settings());
    }

    private Settings loadSingleFromDatabase(String tagId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE tag_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.settings(), stmt -> stmt.setString(1, tagId));
    }

    public Settings get(String tagId) {
        return (Settings)this.cache.get((Object)tagId);
    }

    public List<Settings> getCachedSettings() {
        List settings = (List)this.listCache.get((Object)ALL_KEY);
        if (settings == null || settings.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(settings);
    }

    public void put(Settings settings) {
        this.cache.put((Object)settings.tagId(), (Object)settings);
        CacheUtil.put(this.listCache, ALL_KEY, settings, v -> v.tagId().equals(settings.tagId()));
    }

    public void remove(String tagId) {
        this.cache.invalidate((Object)tagId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.tagId().equals(tagId));
    }

    public void clear() {
        this.cache.invalidateAll();
        this.listCache.invalidateAll();
    }
}

