/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.audit;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLog;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLogCache;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLogProvider;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

public final class PunishmentLogProviderImpl
implements PunishmentLogProvider {
    private static final String TABLE_NAME = "punishment_logs";
    private final Database database;
    private final PunishmentLogCache cache;
    private final RefreshType all = RefreshType.PUNISHMENT_LOGS;
    private final RefreshType single = RefreshType.SINGLE_PUNISHMENT_LOG;

    public PunishmentLogProviderImpl(Database database, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.cache = new PunishmentLogCache(database, TABLE_NAME, fetchLimit, cacheCapacity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id VARCHAR(36) PRIMARY KEY, action ENUM('CREATED', 'MODIFIED', 'REVOKED') NOT NULL, user_id INT NULL, ip_address VARCHAR(45) NULL, CONSTRAINT chk_user_or_ip_not_both_null CHECK (user_id IS NOT NULL OR ip_address IS NOT NULL), reason_id INT NULL, reason_type_id INT NOT NULL, reason_text TEXT NOT NULL, reason_duration BIGINT NULL, reason_auto_flag_ip BOOLEAN NOT NULL, reason_auto_punish BOOLEAN NOT NULL, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), FOREIGN KEY (user_id) REFERENCES users(id), FOREIGN KEY (reason_id) REFERENCES punishment_reasons(id) ON DELETE SET NULL ON UPDATE CASCADE, FOREIGN KEY (created_by) REFERENCES users(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_audit_user ON punishment_logs (user_id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_audit_ip ON punishment_logs (ip_address)");
        database.update("CREATE INDEX IF NOT EXISTS idx_audit_reason ON punishment_logs (reason_id)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public PunishmentLog getLog(UUID logId) {
        return this.cache.getById(logId);
    }

    @Override
    public List<PunishmentLog> getLogsByUserId(int userId) {
        return this.cache.getByUser(userId);
    }

    @Override
    public List<PunishmentLog> getLogsByIpAddress(String ipAddress) {
        return this.cache.getByIp(ipAddress);
    }

    @Override
    public List<PunishmentLog> getLogs() {
        return this.cache.getCachedPunishLogs();
    }

    private PunishmentLog insertAndLoadLog(PunishmentLog.Action action, Integer userId, String ipAddress, PunishmentReason reason, int createdBy) {
        if (action == null || userId != null && userId < 1 || reason == null || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO punishment_logs (id, action, user_id, ip_address, reason_id, reason_type_id, reason_text, reason_duration, reason_auto_flag_ip, reason_auto_punish, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        UUID logId = UUID.randomUUID();
        int row = this.database.update(insertSql, stmt -> {
            stmt.setString(1, logId.toString());
            stmt.setString(2, action.name());
            stmt.setInt(3, userId == null ? 0 : userId);
            stmt.setString(4, ipAddress);
            stmt.setInt(5, reason.id());
            stmt.setInt(6, reason.typeId());
            stmt.setString(7, reason.reasonText());
            stmt.setLong(8, reason.durationSecs());
            stmt.setBoolean(9, reason.autoFlagIp());
            stmt.setBoolean(10, reason.autoPunish());
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM punishment_logs WHERE id = ?";
        LocalDateTime createdAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> stmt.setString(1, logId.toString()));
        if (createdAt == null) {
            return null;
        }
        return new PunishmentLog(logId, action, userId, ipAddress, reason.id(), reason.typeId(), reason.reasonText(), reason.durationSecs(), reason.autoFlagIp(), reason.autoPunish(), createdBy, createdAt);
    }

    @Override
    public PunishmentLog create(Integer userId, String ipAddress, PunishmentReason reason, int createdBy) {
        if (userId != null && userId < 1 || reason == null || createdBy < -1) {
            return null;
        }
        PunishmentLog.Action action = PunishmentLog.Action.CREATED;
        PunishmentLog log = this.insertAndLoadLog(action, userId, ipAddress, reason, createdBy);
        if (log == null) {
            return null;
        }
        RefreshUtil.fireSingle(this.single, log.id());
        return log;
    }

    @Override
    public PunishmentLog modify(Integer userId, String ipAddress, PunishmentReason reason, int createdBy) {
        if (userId != null && userId < 1 || reason == null || createdBy < -1) {
            return null;
        }
        PunishmentLog.Action action = PunishmentLog.Action.MODIFIED;
        PunishmentLog log = this.insertAndLoadLog(action, userId, ipAddress, reason, createdBy);
        if (log == null) {
            return null;
        }
        RefreshUtil.fireSingle(this.single, log.id());
        return log;
    }

    @Override
    public PunishmentLog revoke(Integer userId, String ipAddress, PunishmentLog log, int createdBy) {
        PunishmentLog.Action action;
        if (userId != null && userId < 1 || log == null || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO punishment_logs (id, action, user_id, ip_address, reason_id, reason_type_id, reason_text, reason_duration, reason_auto_flag_ip, reason_auto_punish, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        UUID logId = UUID.randomUUID();
        int row = this.database.update(insertSql, arg_0 -> PunishmentLogProviderImpl.lambda$revoke$3(logId, action = PunishmentLog.Action.REVOKED, userId, ipAddress, log, arg_0));
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM punishment_logs WHERE id = ?";
        LocalDateTime createdAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> stmt.setString(1, logId.toString()));
        if (createdAt == null) {
            return null;
        }
        PunishmentLog newLog = new PunishmentLog(logId, action, userId, ipAddress, log.reasonId(), log.reasonTypeId(), log.reasonText(), log.reasonDuration(), log.reasonAutoFlagIp(), log.reasonAutoPunish(), createdBy, createdAt);
        RefreshUtil.fireSingle(this.single, newLog.id());
        return newLog;
    }

    private static /* synthetic */ void lambda$revoke$3(UUID logId, PunishmentLog.Action action, Integer userId, String ipAddress, PunishmentLog log, PreparedStatement stmt) throws SQLException {
        stmt.setString(1, logId.toString());
        stmt.setString(2, action.name());
        stmt.setInt(3, userId == null ? 0 : userId);
        stmt.setString(4, ipAddress);
        stmt.setInt(5, log.reasonId());
        stmt.setInt(6, log.reasonTypeId());
        stmt.setString(7, log.reasonText());
        stmt.setLong(8, log.reasonDuration());
        stmt.setBoolean(9, log.reasonAutoFlagIp());
        stmt.setBoolean(10, log.reasonAutoPunish());
    }
}

