/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.permission;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.group.parent.GroupParentProvider;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.permission.Permission;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.UserProvider;
import de.murmelmeister.murmelapi.user.parent.UserParentProvider;
import de.murmelmeister.murmelapi.user.permission.UserPermissionProvider;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class PermissionProvider
implements Permission,
RefreshListener,
AutoCloseable {
    private final Database database;
    private final UserProvider userProvider;
    private final GroupParentProvider groupParentProvider;
    private final GroupPermissionProvider groupPermissionProvider;
    private final UserParentProvider userParentProvider;
    private final UserPermissionProvider userPermissionProvider;
    private final LoadingCache<Integer, Set<String>> cache;

    public PermissionProvider(Database database, UserProvider userProvider, GroupParentProvider groupParentProvider, GroupPermissionProvider groupPermissionProvider, UserParentProvider userParentProvider, UserPermissionProvider userPermissionProvider, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.userProvider = userProvider;
        this.groupParentProvider = groupParentProvider;
        this.groupPermissionProvider = groupPermissionProvider;
        this.userParentProvider = userParentProvider;
        this.userPermissionProvider = userPermissionProvider;
        this.cache = CacheUtil.buildCacheRefresh(this::loadAllFromDatabase, cacheCapcity, refreshInterval);
        RefreshUtil.register(this);
    }

    private Set<String> loadAllFromDatabase(int userId) {
        return new LinkedHashSet<String>(this.database.queryListCallable("CALL getUserPermission(?)", resultSet -> resultSet.getString("permission"), stmt -> stmt.setInt(1, userId)));
    }

    public static void setup(Database database) {
        database.update(Database.getProcedureQuery((String)"getUserPermission", (String)"p_user_id INT", (String)"     WITH RECURSIVE grp(grp_id) AS (\n         SELECT parent_id AS grp_id\n         FROM   user_parent\n         WHERE  user_id = p_user_id\n           AND (expires_at IS NULL OR expires_at > CURRENT_TIMESTAMP())\n         UNION ALL\n         SELECT gp.parent_id\n         FROM   group_parent gp\n         JOIN   grp g ON g.grp_id = gp.group_id\n         WHERE  gp.expires_at IS NULL OR gp.expires_at > CURRENT_TIMESTAMP()\n     ),\n     \n     perms AS (\n         SELECT permission\n         FROM   user_permission\n         WHERE  user_id = p_user_id\n           AND (expires_at IS NULL OR expires_at > CURRENT_TIMESTAMP())\n         UNION\n         SELECT permission\n         FROM   group_permission\n         WHERE  group_id IN (SELECT grp_id FROM grp)\n           AND (expires_at IS NULL OR expires_at > CURRENT_TIMESTAMP())\n     )\n     \n     SELECT DISTINCT permission\n     FROM   perms\n     ORDER BY permission;\n "));
    }

    @Override
    public Set<String> getPermissions(int userId) {
        return (Set)this.cache.get((Object)userId);
    }

    @Override
    public boolean hasPermission(User user, String permission) {
        String prefix;
        if (user.id() < -1 || permission == null || permission.isEmpty()) {
            return false;
        }
        if (user.systemUser()) {
            return true;
        }
        Set<String> permissions = this.getPermissions(user.id());
        if (permissions.isEmpty()) {
            return false;
        }
        if (permissions.contains("-" + permission)) {
            return false;
        }
        for (String negative : permissions) {
            if (!negative.startsWith("-") || !negative.endsWith(".*") || !permission.startsWith(prefix = negative.substring(1, negative.length() - 1))) continue;
            return false;
        }
        if (permissions.contains("*")) {
            return true;
        }
        if (permissions.contains(permission)) {
            return true;
        }
        for (String perm : permissions) {
            if (!perm.endsWith(".*") || !permission.startsWith(prefix = perm.substring(0, perm.length() - 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(UUID uuid, String permission) {
        User user = this.userProvider.findByMojangId(uuid);
        if (user == null) {
            return false;
        }
        return this.hasPermission(user, permission);
    }

    @Override
    public int loadExpired() {
        int groupParentExpired = this.groupParentProvider.loadExpired();
        int groupPermissionExpired = this.groupPermissionProvider.loadExpired();
        int userParentExpired = this.userParentProvider.loadExpired();
        int userPermissionExpired = this.userPermissionProvider.loadExpired();
        return groupParentExpired + groupPermissionExpired + userParentExpired + userPermissionExpired;
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_PERMISSIONS.getName().equalsIgnoreCase(cacheName) || RefreshType.GROUP_PERMISSIONS.getName().equalsIgnoreCase(cacheName) || RefreshType.USER_PARENTS.getName().equalsIgnoreCase(cacheName) || RefreshType.GROUP_PARENTS.getName().equalsIgnoreCase(cacheName) || RefreshType.SINGLE_USER_PERMISSION.getName().equalsIgnoreCase(cacheName) || RefreshType.SINGLE_GROUP_PERMISSION.getName().equalsIgnoreCase(cacheName) || RefreshType.SINGLE_USER_PARENT.getName().equalsIgnoreCase(cacheName) || RefreshType.SINGLE_GROUP_PARENT.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.cache.invalidateAll();
            List<Integer> userIds = this.userProvider.findAll().stream().map(User::id).toList();
            userIds.forEach(id -> this.cache.put(id, this.loadAllFromDatabase((int)id)));
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.cache.invalidateAll();
    }

    @Override
    public void closeCache() {
        this.close();
    }
}

