/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import de.murmelmeister.murmelapi.language.message.MessageService;
import de.murmelmeister.murmelapi.language.message.MurmelMessage;
import de.murmelmeister.murmelapi.utils.TimeFilterUtil;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtil {
    private static final Pattern TIME_PATTERN = Pattern.compile("^(\\d+)([smhdwMy])$");

    public static long parseDurationInSeconds(String time) {
        if ("-1".equals(time)) {
            return -1L;
        }
        if (time.startsWith("-")) {
            return -2L;
        }
        Matcher matcher = TIME_PATTERN.matcher(time);
        if (!matcher.matches()) {
            return -3L;
        }
        long duration = Long.parseLong(matcher.group(1));
        return switch (matcher.group(2)) {
            case "s" -> duration;
            case "m" -> TimeUnit.MINUTES.toSeconds(duration);
            case "h" -> TimeUnit.HOURS.toSeconds(duration);
            case "d" -> TimeUnit.DAYS.toSeconds(duration);
            case "w" -> TimeUnit.DAYS.toSeconds(duration * 7L);
            case "M" -> TimeUnit.DAYS.toSeconds(duration * 30L);
            case "y" -> TimeUnit.DAYS.toSeconds(duration * 365L);
            default -> -4L;
        };
    }

    public static String formatDuration(MessageService messageService, int languageId, long totalSeconds, TimeFilterUtil ... filters) {
        if (totalSeconds <= 0L) {
            return "0 seconds";
        }
        Duration duration = Duration.ofSeconds(totalSeconds);
        long totalDays = duration.toDays();
        long years = totalDays / 365L;
        long days = totalDays % 365L;
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        EnumSet<TimeFilterUtil> excludedFilters = filters == null || filters.length == 0 ? EnumSet.noneOf(TimeFilterUtil.class) : EnumSet.copyOf(Arrays.asList(filters));
        StringBuilder builder = new StringBuilder();
        boolean appended = false;
        if (!excludedFilters.contains((Object)TimeFilterUtil.YEARS) && years > 0L) {
            builder.append(years).append(" ").append(years == 1L ? messageService.getMessage(MurmelMessage.TIME_YEAR_SINGULAR.getTag(), languageId) : messageService.getMessage(MurmelMessage.TIME_YEAR_PLURAL.getTag(), languageId)).append(" ");
            appended = true;
        }
        if (!excludedFilters.contains((Object)TimeFilterUtil.DAYS) && days > 0L) {
            builder.append(days).append(" ").append(days == 1L ? messageService.getMessage(MurmelMessage.TIME_DAY_SINGULAR.getTag(), languageId) : messageService.getMessage(MurmelMessage.TIME_DAY_PLURAL.getTag(), languageId)).append(" ");
            appended = true;
        }
        if (!excludedFilters.contains((Object)TimeFilterUtil.HOURS) && hours > 0L) {
            builder.append(hours).append(" ").append(hours == 1L ? messageService.getMessage(MurmelMessage.TIME_HOUR_SINGULAR.getTag(), languageId) : messageService.getMessage(MurmelMessage.TIME_HOUR_PLURAL.getTag(), languageId)).append(" ");
            appended = true;
        }
        if (!excludedFilters.contains((Object)TimeFilterUtil.MINUTES) && minutes > 0L) {
            builder.append(minutes).append(" ").append(minutes == 1L ? messageService.getMessage(MurmelMessage.TIME_MINUTE_SINGULAR.getTag(), languageId) : messageService.getMessage(MurmelMessage.TIME_MINUTE_PLURAL.getTag(), languageId)).append(" ");
            appended = true;
        }
        if (!excludedFilters.contains((Object)TimeFilterUtil.SECONDS) && seconds > 0L) {
            builder.append(seconds).append(" ").append(seconds == 1L ? messageService.getMessage(MurmelMessage.TIME_SECOND_SINGULAR.getTag(), languageId) : messageService.getMessage(MurmelMessage.TIME_SECOND_PLURAL.getTag(), languageId));
            appended = true;
        }
        if (!appended) {
            TimeFilterUtil fallbackFilter = Arrays.stream(TimeFilterUtil.values()).filter(filter -> !excludedFilters.contains(filter)).reduce((first, second) -> second).orElse(null);
            if (fallbackFilter == null) {
                return "0 seconds";
            }
            MurmelMessage pluralMessage = switch (fallbackFilter) {
                default -> throw new MatchException(null, null);
                case TimeFilterUtil.YEARS -> MurmelMessage.TIME_YEAR_PLURAL;
                case TimeFilterUtil.DAYS -> MurmelMessage.TIME_DAY_PLURAL;
                case TimeFilterUtil.HOURS -> MurmelMessage.TIME_HOUR_PLURAL;
                case TimeFilterUtil.MINUTES -> MurmelMessage.TIME_MINUTE_PLURAL;
                case TimeFilterUtil.SECONDS -> MurmelMessage.TIME_SECOND_PLURAL;
            };
            builder.append("0 ").append(messageService.getMessage(pluralMessage.getTag(), languageId));
            return builder.toString();
        }
        return builder.toString().trim();
    }
}

