/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.session;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.user.session.UserSession;
import de.murmelmeister.murmelapi.user.session.UserSessionCache;
import de.murmelmeister.murmelapi.user.session.UserSessionProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

public final class UserSessionProviderImpl
implements UserSessionProvider {
    private static final String TABLE_NAME = "user_session";
    private final Database database;
    private final UserSessionCache cache;
    private final RefreshType all = RefreshType.USER_SESSIONS;
    private final RefreshType single = RefreshType.SINGLE_USER_SESSION;

    public UserSessionProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new UserSessionCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id VARCHAR(36) PRIMARY KEY, user_id INT NOT NULL UNIQUE, login_time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), ip_address VARCHAR(45) NOT NULL, client_brand VARCHAR(50) NULL, protocol_version INT NULL, FOREIGN KEY (user_id) REFERENCES users(id)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public UserSession findById(UUID sessionId) {
        return this.cache.getById(sessionId);
    }

    @Override
    public UserSession findByUserId(int userId) {
        return this.cache.getByUserId(userId);
    }

    @Override
    public List<UserSession> findAll() {
        return this.cache.getCachedSessions();
    }

    @Override
    public List<UserSession> findUserSessions(int userId) {
        return this.findAll().stream().filter(session -> session.userId() == userId).toList();
    }

    @Override
    public UserSession create(int userId, String ipAddress, String clientBrand, int protocolVersion) {
        String normalizeIpAddress = StringUtil.normalize(ipAddress);
        if (userId < 1 || normalizeIpAddress == null) {
            return null;
        }
        String insertSql = "INSERT INTO user_session (id, user_id, ip_address, client_brand, protocol_version) VALUES (?, ?, ?, ?, ?)";
        UUID sessionId = UUID.randomUUID();
        int row = this.database.update(insertSql, stmt -> {
            stmt.setString(1, sessionId.toString());
            stmt.setInt(2, userId);
            stmt.setString(3, normalizeIpAddress);
            stmt.setString(4, clientBrand);
            stmt.setInt(5, protocolVersion);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT login_time FROM user_session WHERE id = ?";
        LocalDateTime loginTime = this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("login_time").toLocalDateTime(), stmt -> stmt.setString(1, sessionId.toString()));
        if (loginTime == null) {
            return null;
        }
        UserSession session = new UserSession(sessionId, userId, loginTime, normalizeIpAddress, clientBrand, protocolVersion);
        RefreshUtil.fireSingle(this.single, session.id());
        return session;
    }

    @Override
    public int delete(UUID sessionId) {
        if (sessionId == null) {
            return 0;
        }
        String sql = "DELETE FROM user_session WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setString(1, sessionId.toString()));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, sessionId);
        return row;
    }

    @Override
    public boolean isOnline(int userId) {
        if (userId < 1) {
            return false;
        }
        return this.findByUserId(userId) != null;
    }
}

