/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.playtime;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTime;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class UserPlayTimeCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<Integer, UserPlayTime> cache;
    private final LoadingCache<String, List<UserPlayTime>> listCache;
    private final Long fetchLimit;

    public UserPlayTimeCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cache = CacheUtil.buildCacheRefresh(this::loadById, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_PLAY_TIMES.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER_PLAY_TIME.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof Integer) {
                    Integer userId = (Integer)key;
                    this.refreshSingle(userId);
                }
            } else {
                int userId = Integer.parseInt((String)key);
                this.refreshSingle(userId);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<UserPlayTime> playTimes = this.loadAllFromDatabase();
        if (playTimes.isEmpty()) {
            return;
        }
        playTimes.forEach(playTime -> this.cache.put(playTime.getUserId(), (UserPlayTime)playTime));
        this.listCache.put(ALL_KEY, List.copyOf(playTimes));
    }

    private void refreshSingle(int userId) {
        this.remove(userId);
        UserPlayTime playTime = this.loadById(userId);
        if (playTime != null) {
            this.put(playTime);
        }
    }

    private List<UserPlayTime> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userPlayTime());
    }

    private UserPlayTime loadById(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userPlayTime(), stmt -> stmt.setInt(1, userId));
    }

    public UserPlayTime get(int userId) {
        return this.cache.get(userId);
    }

    public void put(UserPlayTime playTime) {
        this.cache.put(playTime.getUserId(), playTime);
        CacheUtil.put(this.listCache, ALL_KEY, playTime, v -> v.getUserId() == playTime.getUserId());
    }

    public void remove(int userId) {
        this.cache.invalidate(userId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.getUserId() == userId);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<UserPlayTime> getCachedPlayTimes() {
        List<UserPlayTime> playTimes = this.listCache.get(ALL_KEY);
        if (playTimes == null || playTimes.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(playTimes);
    }
}

