/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.user;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.user.PunishmentCurrentUser;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PunishmentCurrentUserCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private static final Pattern KEY_PATTERN = Pattern.compile(".*userId=(\\d+), typeId=(\\d+).*");
    private final Database database;
    private final String tableName;
    private final LoadingCache<UserTypeKey, PunishmentCurrentUser> cache;
    private final LoadingCache<String, List<PunishmentCurrentUser>> listCache;
    private final Long fetchLimit;

    public PunishmentCurrentUserCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cache = CacheUtil.buildCacheRefresh(this::loadFromDatabase, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.PUNISHMENT_USERS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_PUNISHMENT_USER.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof UserTypeKey) {
                    UserTypeKey userTypeKey = (UserTypeKey)key;
                    this.refreshSingle(userTypeKey);
                }
            } else {
                Matcher matcher = KEY_PATTERN.matcher((String)key);
                if (matcher.matches()) {
                    int userId = Integer.parseInt(matcher.group(1));
                    int typeId = Integer.parseInt(matcher.group(2));
                    this.refreshSingle(new UserTypeKey(userId, typeId));
                } else {
                    throw new IllegalArgumentException("Invalid key format: " + String.valueOf(key));
                }
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<PunishmentCurrentUser> punishments = this.loadAllFromDatabase();
        if (punishments.isEmpty()) {
            return;
        }
        punishments.forEach(punish -> this.cache.put(new UserTypeKey(punish.userId(), punish.typeId()), (PunishmentCurrentUser)punish));
        this.listCache.put(ALL_KEY, List.copyOf(punishments));
    }

    private void refreshSingle(UserTypeKey key) {
        this.remove(key.userId(), key.typeId());
        PunishmentCurrentUser punishment = this.loadFromDatabase(key);
        if (punishment != null) {
            this.put(punishment);
        }
    }

    private List<PunishmentCurrentUser> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentCurrentUser());
    }

    private PunishmentCurrentUser loadFromDatabase(UserTypeKey key) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ? AND type_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentCurrentUser(), stmt -> {
            stmt.setInt(1, key.userId());
            stmt.setInt(2, key.typeId());
        });
    }

    public PunishmentCurrentUser get(int userId, int typeId) {
        return this.cache.get(new UserTypeKey(userId, typeId));
    }

    public void put(PunishmentCurrentUser punish) {
        UserTypeKey key = new UserTypeKey(punish.userId(), punish.typeId());
        this.cache.put(key, punish);
        CacheUtil.put(this.listCache, ALL_KEY, punish, v -> v.userId() == punish.userId() && v.typeId() == punish.typeId());
    }

    public void remove(int userId, int typeId) {
        UserTypeKey key = new UserTypeKey(userId, typeId);
        this.cache.invalidate(key);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.userId() == userId && v.typeId() == typeId);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<PunishmentCurrentUser> getCachedPunishUsers() {
        List<PunishmentCurrentUser> users = this.listCache.get(ALL_KEY);
        if (users == null || users.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(users);
    }

    protected record UserTypeKey(int userId, int typeId) {
    }
}

