/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.reason;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReasonCache;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReasonProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public final class PunishmentReasonProviderImpl
implements PunishmentReasonProvider {
    private static final String TABLE_NAME = "punishment_reasons";
    private final Database database;
    private final PunishmentReasonCache cache;
    private final RefreshType all = RefreshType.PUNISHMENT_REASONS;
    private final RefreshType single = RefreshType.SINGLE_PUNISHMENT_REASON;

    public PunishmentReasonProviderImpl(Database database, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.cache = new PunishmentReasonCache(database, TABLE_NAME, fetchLimit, cacheCapacity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT PRIMARY KEY, type_id INT NOT NULL, reason_text TEXT NOT NULL, duration_secs BIGINT NULL, auto_flag_ip BOOLEAN NOT NULL DEFAULT FALSE, auto_punish BOOLEAN NOT NULL DEFAULT FALSE, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), changed_by INT NULL, changed_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP(), FOREIGN KEY (type_id) REFERENCES punishment_types(id), FOREIGN KEY (created_by) REFERENCES users(id), FOREIGN KEY (changed_by) REFERENCES users(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_reason_type ON punishment_reasons (type_id)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public PunishmentReason getReason(int id) {
        return this.cache.getById(id);
    }

    @Override
    public List<PunishmentReason> getReasonsByType(int typeId) {
        return this.cache.getByType(typeId);
    }

    @Override
    public List<PunishmentReason> getAllReasons() {
        return this.cache.getCachedPunishReasons();
    }

    @Override
    public PunishmentReason create(int id, int typeId, String reasonText, Long durationSecs, boolean autoFlagIp, boolean autoPunish, int createdBy) {
        if (id < 1 || typeId < 1 || reasonText == null || reasonText.isEmpty() || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO punishment_reasons (id, type_id, reason_text, duration_secs, auto_flag_ip, auto_punish, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)";
        int row = this.database.update(insertSql, stmt -> {
            stmt.setInt(1, id);
            stmt.setInt(2, typeId);
            stmt.setString(3, reasonText);
            stmt.setLong(4, durationSecs);
            stmt.setBoolean(5, autoFlagIp);
            stmt.setBoolean(6, autoPunish);
            stmt.setInt(7, createdBy);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM punishment_reasons WHERE id = ?";
        LocalDateTime createdAt = this.database.query(selectSql, null, result -> result.getTimestamp("created_at").toLocalDateTime(), stmt -> stmt.setInt(1, id));
        if (createdAt == null) {
            return null;
        }
        PunishmentReason reason = new PunishmentReason(id, typeId, reasonText, durationSecs, autoFlagIp, autoPunish, createdBy, createdAt, null, null);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(reason.id()));
        return reason;
    }

    @Override
    public int delete(int id) {
        String sql = "DELETE FROM punishment_reasons WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, id));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return row;
    }

    @Override
    public PunishmentReason update(int id, int typeId, String reasonText, Long durationSecs, boolean autoFlagIp, boolean autoPunish, int changedBy) {
        if (id < 1 || typeId < 1 || reasonText == null || reasonText.isEmpty() || changedBy < -1) {
            return null;
        }
        PunishmentReason existing = this.cache.getById(id);
        if (existing == null) {
            return null;
        }
        if (typeId == existing.typeId() && Objects.equals(reasonText, existing.reasonText()) && Objects.equals(durationSecs, existing.durationSecs()) && autoFlagIp == existing.autoFlagIp() && autoPunish == existing.autoPunish()) {
            return existing;
        }
        String insertSql = "UPDATE punishment_reasons SET type_id = ?, reason_text = ?, duration_secs = ?, auto_flag_ip = ?, auto_punish = ?, changed_by = ? WHERE id = ?";
        int row = this.database.update(insertSql, stmt -> {
            stmt.setInt(1, typeId);
            stmt.setString(2, reasonText);
            stmt.setLong(3, durationSecs);
            stmt.setBoolean(4, autoFlagIp);
            stmt.setBoolean(5, autoPunish);
            stmt.setInt(6, changedBy);
            stmt.setInt(7, id);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT changed_at FROM punishment_reasons WHERE id = ?";
        LocalDateTime changedAt = this.database.query(selectSql, null, result -> result.getTimestamp("changed_at").toLocalDateTime(), stmt -> stmt.setInt(1, id));
        if (changedAt == null) {
            return null;
        }
        PunishmentReason reason = existing.withUpdateMeta(typeId, reasonText, durationSecs, autoFlagIp, autoPunish, changedBy, changedAt);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return reason;
    }
}

