/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.ip;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.ip.PunishmentCurrentIp;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PunishmentCurrentIpCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private static final Pattern KEY_PATTERN = Pattern.compile(".*ipAddress=([^,]+), typeId=(\\d+).*");
    private final Database database;
    private final String tableName;
    private final LoadingCache<IpTypeKey, PunishmentCurrentIp> cache;
    private final LoadingCache<String, List<PunishmentCurrentIp>> listCache;
    private final Long fetchLimit;

    public PunishmentCurrentIpCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cache = CacheUtil.buildCacheRefresh(this::loadFromDatabase, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.PUNISHMENT_IPS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_PUNISHMENT_IP.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof IpTypeKey) {
                    IpTypeKey ipTypeKey = (IpTypeKey)key;
                    this.refreshSingle(ipTypeKey);
                }
            } else {
                Matcher matcher = KEY_PATTERN.matcher((String)key);
                if (matcher.matches()) {
                    String ipAddress = matcher.group(1);
                    int typeId = Integer.parseInt(matcher.group(2));
                    this.refreshSingle(new IpTypeKey(ipAddress, typeId));
                } else {
                    throw new IllegalArgumentException("Invalid key format: " + String.valueOf(key));
                }
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<PunishmentCurrentIp> punishments = this.loadAllFromDatabase();
        if (punishments.isEmpty()) {
            return;
        }
        punishments.forEach(punish -> this.cache.put(new IpTypeKey(punish.ipAddress(), punish.typeId()), (PunishmentCurrentIp)punish));
        this.listCache.put(ALL_KEY, List.copyOf(punishments));
    }

    private void refreshSingle(IpTypeKey key) {
        this.remove(key.ipAddress(), key.typeId());
        PunishmentCurrentIp punishment = this.loadFromDatabase(key);
        if (punishment != null) {
            this.put(punishment);
        }
    }

    private List<PunishmentCurrentIp> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentCurrentIp());
    }

    private PunishmentCurrentIp loadFromDatabase(IpTypeKey key) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE ip_address = ? AND type_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentCurrentIp(), stmt -> {
            stmt.setString(1, key.ipAddress());
            stmt.setInt(2, key.typeId());
        });
    }

    public PunishmentCurrentIp get(String ipAddress, int typeId) {
        return this.cache.get(new IpTypeKey(ipAddress, typeId));
    }

    public void put(PunishmentCurrentIp punish) {
        IpTypeKey key = new IpTypeKey(punish.ipAddress(), punish.typeId());
        this.cache.put(key, punish);
        CacheUtil.put(this.listCache, ALL_KEY, punish, v -> v.ipAddress().equals(key.ipAddress()) && v.typeId() == key.typeId());
    }

    public void remove(String ipAddress, int typeId) {
        IpTypeKey key = new IpTypeKey(ipAddress, typeId);
        this.cache.invalidate(key);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.ipAddress().equals(ipAddress) && v.typeId() == typeId);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<PunishmentCurrentIp> getCachedPunishIPs() {
        List<PunishmentCurrentIp> ips = this.listCache.get(ALL_KEY);
        if (ips == null || ips.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(ips);
    }

    protected record IpTypeKey(String ipAddress, int typeId) {
    }
}

