/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.language.message;

import de.murmelmeister.murmelapi.language.Language;
import de.murmelmeister.murmelapi.language.LanguageProvider;
import de.murmelmeister.murmelapi.language.message.Message;
import de.murmelmeister.murmelapi.language.message.MessageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageService {
    private final Logger logger = LoggerFactory.getLogger(MessageService.class);
    private final LanguageProvider languageProvider;
    private final MessageProvider messageProvider;

    public MessageService(LanguageProvider languageProvider, MessageProvider provider) {
        this.languageProvider = languageProvider;
        this.messageProvider = provider;
    }

    public String getMessage(String key, int languageId) {
        Message fallback;
        Language defaultLanguage;
        Language language = this.languageProvider.get(languageId);
        if (language != null) {
            Message message = this.messageProvider.get(key, language.id());
            if (message != null) {
                return message.message();
            }
            this.logger.warn("Message with tag '{}' and language ID '{}' not found.", (Object)key, (Object)language.id());
        }
        if ((defaultLanguage = this.languageProvider.get("en-US")) != null && (fallback = this.messageProvider.get(key, defaultLanguage.id())) != null) {
            return fallback.message();
        }
        return null;
    }

    public String getMessage(String key, String code) {
        Message fallback;
        Language defaultLanguage;
        Language language = this.languageProvider.get(code);
        if (language != null) {
            Message message = this.messageProvider.get(key, language.id());
            if (message != null) {
                return message.message();
            }
            this.logger.warn("Message with tag '{}' and language ID '{}' not found.", (Object)key, (Object)language.id());
        }
        if ((defaultLanguage = this.languageProvider.get("en-US")) != null && (fallback = this.messageProvider.get(key, defaultLanguage.id())) != null) {
            return fallback.message();
        }
        return null;
    }
}

