/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.library.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.murmelmeister.library.exceptions.JsonMurmelException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JsonMurmel {
    private final Path path;
    private final Gson gson;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public JsonMurmel(String fileName) {
        this.path = Path.of(fileName, new String[0]);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public JsonMurmel(Path path) {
        this.path = path;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public <T> T getValue(String key, Class<T> type) {
        this.lock.readLock().lock();
        try {
            if (Files.notExists(this.path, new LinkOption[0])) {
                T t2 = null;
                return t2;
            }
            String content = Files.readString(this.path);
            JsonObject root = JsonParser.parseString(content).getAsJsonObject();
            String[] keys = key.split("\\.");
            JsonElement current = root;
            for (String part : keys) {
                if (current == null || current.isJsonNull() || !current.isJsonObject()) {
                    T t3 = null;
                    return t3;
                }
                current = current.getAsJsonObject().get(part);
            }
            JsonObject element = current;
            if (element == null || element.isJsonNull()) {
                T t4 = null;
                return t4;
            }
            T t5 = this.gson.fromJson((JsonElement)element, type);
            return t5;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T> T getValue(String key, Class<T> type, T fallback) {
        T value = this.getValue(key, type);
        if (value != null) {
            return value;
        }
        this.setValue(key, fallback);
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setValue(String key, T value) {
        this.lock.writeLock().lock();
        try {
            JsonObject root;
            if (Files.exists(this.path, new LinkOption[0])) {
                try {
                    String content = Files.readString(this.path);
                    root = JsonParser.parseString(content).getAsJsonObject();
                }
                catch (IOException e) {
                    throw new JsonMurmelException("Error reading file: " + String.valueOf(this.path), e);
                }
            } else {
                root = new JsonObject();
            }
            String[] keys = key.split("\\.");
            JsonObject current = root;
            for (int i = 0; i < keys.length - 1; ++i) {
                String part = keys[i];
                if (!current.has(part) || !current.get(part).isJsonObject()) {
                    current.add(part, new JsonObject());
                }
                current = current.getAsJsonObject(part);
            }
            String lastKey = keys[keys.length - 1];
            current.add(lastKey, this.gson.toJsonTree(value));
            try {
                if (this.path.getParent() != null) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                }
                Files.write(this.path, this.gson.toJson(root).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new JsonMurmelException("Error writing to file: " + String.valueOf(this.path), e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(String key) {
        block14: {
            this.lock.writeLock().lock();
            try {
                JsonObject removed;
                JsonObject root;
                if (Files.exists(this.path, new LinkOption[0])) {
                    try {
                        String content = Files.readString(this.path);
                        root = JsonParser.parseString(content).getAsJsonObject();
                    }
                    catch (IOException e) {
                        throw new JsonMurmelException("Error reading file: " + String.valueOf(this.path), e);
                    }
                } else {
                    return;
                }
                String[] keys = key.split("\\.");
                int depth = keys.length;
                JsonObject[] nodeStack = new JsonObject[depth];
                String[] keyStack = new String[depth];
                JsonObject current = root;
                for (int i = 0; i < depth - 1; ++i) {
                    String part = keys[i];
                    if (!current.has(part) || !current.get(part).isJsonObject()) {
                        return;
                    }
                    nodeStack[i] = current;
                    keyStack[i] = part;
                    current = current.getAsJsonObject(part);
                }
                nodeStack[depth - 1] = current;
                keyStack[depth - 1] = keys[depth - 1];
                String lastKey = keys[depth - 1];
                if (!current.has(lastKey)) break block14;
                current.remove(lastKey);
                for (int level = depth - 1; level > 0 && (removed = nodeStack[level]).isEmpty(); --level) {
                    JsonObject parent = nodeStack[level - 1];
                    String parentKey = keyStack[level - 1];
                    parent.remove(parentKey);
                }
                try {
                    Files.write(this.path, this.gson.toJson(root).getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new JsonMurmelException("Error writing to file: " + String.valueOf(this.path), e);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

