/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.time;

import de.murmelmeister.murmelapi.time.PlayTime;
import de.murmelmeister.murmelapi.time.PlayTimeType;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.utils.Database;

public final class PlayTimeProvider
implements PlayTime {
    public PlayTimeProvider(User user) {
        String tableName = "PlayTime";
        this.createTable(tableName);
        Procedure.loadAll(tableName);
        this.loadTables(user);
    }

    private void createTable(String tableName) {
        Database.createTable(tableName, "UserID INT PRIMARY KEY, Seconds INT");
    }

    @Override
    public boolean existsUser(int userId) {
        return Database.callExists(Procedure.PLAY_TIME_USER_ID.getName(), userId);
    }

    @Override
    public void createUser(int userId) {
        if (this.existsUser(userId)) {
            return;
        }
        Database.callUpdate(Procedure.PLAY_TIME_INSERT.getName(), userId, 0);
    }

    @Override
    public void deleteUser(int userId) {
        Database.callUpdate(Procedure.PLAY_TIME_DELETE.getName(), userId);
    }

    @Override
    public int getTime(int userId) {
        return Database.callQuery(-1, "Seconds", Integer.TYPE, Procedure.PLAY_TIME_USER_ID.getName(), userId);
    }

    @Override
    public void setTime(int userId, int time) {
        Database.callUpdate(Procedure.PLAY_TIME_UPDATE.getName(), userId, time);
    }

    @Override
    public void addTime(int userId) {
        int current = this.getTime(userId);
        this.setTime(userId, ++current);
    }

    @Override
    public void addTime(int userId, PlayTimeType type, int time) {
        int current = this.getTime(userId);
        this.setTime(userId, current += type.toSeconds(time));
    }

    @Override
    public void removeTime(int userId) {
        int current = this.getTime(userId);
        this.setTime(userId, --current);
    }

    @Override
    public void removeTime(int userId, PlayTimeType type, int time) {
        int current = this.getTime(userId);
        this.setTime(userId, current -= type.toSeconds(time));
    }

    @Override
    public void resetTime(int userId) {
        this.setTime(userId, 0);
    }

    private void loadTables(User user) {
        for (int userId : user.getIds()) {
            this.createUser(userId);
        }
    }

    private static enum Procedure {
        PLAY_TIME_USER_ID("PlayTime_UserID", "uid INT", "SELECT * FROM [TABLE] WHERE UserID=uid;"),
        PLAY_TIME_INSERT("PlayTime_Insert", "uid INT, sec INT", "INSERT INTO [TABLE] VALUES (uid, sec);"),
        PLAY_TIME_DELETE("PlayTime_Delete", "uid INT", "DELETE FROM [TABLE] WHERE UserID=uid;"),
        PLAY_TIME_UPDATE("PlayTime_Update", "uid INT, sec INT", "UPDATE [TABLE] SET Seconds=sec WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQueryWithoutObjects(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return this.query.replace("[TABLE]", tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

