/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.bansystem.mute;

import de.murmelmeister.murmelapi.bansystem.log.Log;
import de.murmelmeister.murmelapi.bansystem.log.LogProvider;
import de.murmelmeister.murmelapi.bansystem.mute.Mute;
import de.murmelmeister.murmelapi.bansystem.reason.Reason;
import de.murmelmeister.murmelapi.bansystem.reason.ReasonProvider;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;

public final class MuteProvider
implements Mute {
    private final Reason reason = new ReasonProvider("Mute_Reason");
    private final Log log = new LogProvider("Mute_Log", this.reason);

    public MuteProvider() {
        String tableName = "Mute_List";
        this.createTable(tableName);
        Procedure.loadAll(tableName);
    }

    private void createTable(String tableName) {
        Database.createTable(tableName, "UserID INT, ExpiredTime BIGINT");
    }

    @Override
    public void mute(int userId, int creatorId, int reasonId, long time) {
        int logId = this.log.addLog(userId, creatorId, reasonId, time);
        Database.callUpdate(Procedure.MUTE_ADD.getName(), userId, this.log.getExpiredTime(logId));
    }

    @Override
    public void unmute(int userId) {
        Database.callUpdate(Procedure.MUTE_REMOVE.getName(), userId);
    }

    @Override
    public long getExpiredTime(int userId) {
        return Database.callQuery(-2L, "ExpiredTime", Long.TYPE, Procedure.MUTE_GET.getName(), userId);
    }

    @Override
    public String getExpiredDate(int userId) {
        long time = this.getExpiredTime(userId);
        return time == -1L ? "never" : new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(time);
    }

    @Override
    public boolean isMuted(int userId) {
        long time = this.getExpiredTime(userId);
        return time == -1L || time >= System.currentTimeMillis();
    }

    @Override
    public Reason getReason() {
        return this.reason;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    private static enum Procedure {
        MUTE_ADD("Mute_Add", "uid INT, expired BIGINT", "INSERT INTO [TABLE] VALUES (uid, expired);"),
        MUTE_REMOVE("Mute_Remove", "uid INT", "DELETE FROM [TABLE] WHERE UserID=uid;"),
        MUTE_GET("Mute_Get", "uid INT", "SELECT * FROM [TABLE] WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQueryWithoutObjects(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return this.query.replace("[TABLE]", tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

