/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import de.murmelmeister.murmelapi.time.PlayTime;
import de.murmelmeister.murmelapi.time.PlayTimeType;

public final class TimeUtil {
    public static long formatTime(String args) {
        if (args.equals("-1")) {
            return -1L;
        }
        if (args.startsWith("-")) {
            return -2L;
        }
        try {
            String format = args.substring(args.length() - 1);
            long duration = Long.parseLong(args.substring(0, args.length() - 1));
            return TimeUtil.getTime(format, duration);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    private static long getTime(String format, long duration) {
        return switch (format) {
            case "s" -> duration * 1000L;
            case "m" -> duration * 1000L * 60L;
            case "h" -> duration * 1000L * 60L * 60L;
            case "d" -> duration * 1000L * 60L * 60L * 24L;
            case "w" -> duration * 1000L * 60L * 60L * 24L * 7L;
            case "M" -> duration * 1000L * 60L * 60L * 24L * 30L;
            case "y" -> duration * 1000L * 60L * 60L * 24L * 365L;
            default -> -3L;
        };
    }

    public static String formatTimeValue(PlayTime playTime, int userId) {
        int currentTime = playTime.getTime(userId);
        int years = PlayTimeType.YEARS.fromSeconds(currentTime);
        int days = PlayTimeType.DAYS.fromSeconds(currentTime %= PlayTimeType.YEARS.getMultiplier());
        int hours = PlayTimeType.HOURS.fromSeconds(currentTime %= PlayTimeType.DAYS.getMultiplier());
        int minutes = PlayTimeType.MINUTES.fromSeconds(currentTime %= PlayTimeType.HOURS.getMultiplier());
        int seconds = currentTime % PlayTimeType.MINUTES.getMultiplier();
        return (String)(years != 0 ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS).replace("365 days", "") + " " : "") + (String)(days != 0 ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS).replace("24 hours", "") + " " : "") + (String)(hours != 0 ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS).replace("60 minutes", "") + " " : "") + (String)(minutes != 0 ? TimeUtil.getTimeValue(minutes, PlayTimeType.MINUTES).replace("60 seconds", "") + " " : "") + (seconds != 0 ? TimeUtil.getTimeValue(seconds, PlayTimeType.SECONDS) : "");
    }

    public static String formatScoreboardTime(PlayTime playTime, int userId) {
        int currentTime = playTime.getTime(userId);
        int years = PlayTimeType.YEARS.fromSeconds(currentTime);
        int days = PlayTimeType.DAYS.fromSeconds(currentTime %= PlayTimeType.YEARS.getMultiplier());
        int hours = currentTime % PlayTimeType.DAYS.getMultiplier();
        return (String)(years != 0 ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS).replace("365 days", "") + " " : "") + (String)(days != 0 ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS).replace("24 hours", "") + " " : "") + (hours != 0 ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS) : "0 ");
    }

    private static String getTimeValue(int time, PlayTimeType type) {
        return time == 1 ? "1 " + type.getName().replace("s", "").toLowerCase() : time + " " + type.getName().toLowerCase();
    }
}

