/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils.update;

import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RefreshUtil {
    private static final AtomicBoolean HAS_REFRESH = new AtomicBoolean(false);
    private static final List<RefreshListener> LISTENERS = new ArrayList<RefreshListener>();

    public static void setRefreshListener(RefreshListener listener) {
        LISTENERS.add(listener);
    }

    public static void markAsRefreshed() {
        HAS_REFRESH.set(true);
        for (RefreshListener listener : LISTENERS) {
            listener.onRefreshOccurred();
        }
    }

    public static boolean checkAndResetRefreshStatus() {
        return HAS_REFRESH.getAndSet(false);
    }
}

