/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.murmelmeister.murmelapi.configuration.MurmelConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Map<String, ReentrantLock> FILE_LOCKS = new ConcurrentHashMap<String, ReentrantLock>();
    private static final Map<String, File> FILES = new ConcurrentHashMap<String, File>();
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();

    private static ReentrantLock getLockForFile(String fileName) {
        FILE_LOCKS.putIfAbsent(fileName, new ReentrantLock());
        return FILE_LOCKS.get(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createFile(Logger logger, String path, String fileName) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            boolean exist;
            File file = new File(path, fileName);
            File parent = file.getParentFile();
            if (!parent.exists() && !(exist = parent.mkdirs())) {
                logger.warn("Cloud not create the directory: {}", (Object)parent);
            }
            if (!file.exists()) {
                try {
                    exist = file.createNewFile();
                    if (!exist) {
                        logger.error("Cloud not create the file: {}", (Object)file);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            FILES.put(fileName, file);
            File file2 = file;
            return file2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsFile(String path, String fileName) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            if (!FILES.containsKey(fileName)) {
                File file = new File(path, fileName);
                boolean bl = file.exists();
                return bl;
            }
            boolean bl = FILES.get(fileName).exists();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loadJson(Logger logger, String path, String fileName, Class<T> clazz) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            File file = !FILES.containsKey(fileName) ? FileUtil.createFile(logger, path, fileName) : FILES.get(fileName);
            T t = FileUtil.fromJson(file, clazz);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void saveJson(Logger logger, String fileName, T json) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            if (!FILES.containsKey(fileName)) {
                logger.error("No such file loaded: {}", (Object)fileName);
                return;
            }
            File file = FILES.get(fileName);
            FileUtil.toJson(file, json);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MurmelConfiguration loadConfiguration(Logger logger, String path, String fileName) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            File file = !FILES.containsKey(fileName) ? FileUtil.createFile(logger, path, fileName) : FILES.get(fileName);
            MurmelConfiguration murmelConfiguration = MurmelConfiguration.loadConfiguration(file);
            return murmelConfiguration;
        }
        finally {
            lock.unlock();
        }
    }

    public static MurmelConfiguration loadConfiguration(Logger logger, File file) {
        return FileUtil.loadConfiguration(logger, file.getPath(), file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfiguration(Logger logger, MurmelConfiguration config, String fileName) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            if (!FILES.containsKey(fileName)) {
                logger.error("No such file loaded: {}", (Object)fileName);
                return;
            }
            File file = FILES.get(fileName);
            config.save(file);
        }
        finally {
            lock.unlock();
        }
    }

    public static void saveConfiguration(Logger logger, MurmelConfiguration config, File file) {
        FileUtil.saveConfiguration(logger, config, file.getName());
    }

    public static Properties loadProperties(File file) {
        ReentrantLock lock = FileUtil.getLockForFile(file.getName());
        lock.lock();
        try {
            Properties properties;
            FileInputStream stream = new FileInputStream(file);
            try {
                Properties properties2 = new Properties(System.getProperties());
                properties2.load(stream);
                properties = properties2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load properties from file: " + file.getName(), e);
                }
            }
            stream.close();
            return properties;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> void toJson(File file, T json) {
        ReentrantLock lock = FileUtil.getLockForFile(file.getName());
        lock.lock();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JSON to file: " + file.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T fromJson(File file, Class<T> clazz) {
        ReentrantLock lock = FileUtil.getLockForFile(file.getName());
        lock.lock();
        try {
            Object object;
            FileReader reader = new FileReader(file);
            try {
                object = GSON.fromJson((Reader)reader, clazz);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read JSON from file: " + file.getName(), e);
                }
            }
            ((Reader)reader).close();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }
}

