/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.permission;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.permission.Permission;
import de.murmelmeister.murmelapi.user.User;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;

public record PermissionProvider(Group group, User user) implements Permission
{
    @Override
    public List<String> getPermissions(int userId) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>(this.user.getPermission().getPermissions(userId));
        for (int parentId : this.user.getParent().getParentIds(userId)) {
            permissions.addAll(this.group.getPermission().getAllPermissions(this.group.getParent(), parentId));
        }
        return new ArrayList<String>(permissions);
    }

    @Override
    public boolean hasPermission(UUID uuid, String permission) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>(this.getPermissions(this.user.getId(uuid)));
        if (permissions.contains("-" + permission)) {
            return false;
        }
        if (permissions.contains("*")) {
            return true;
        }
        return permissions.contains(permission);
    }
}

