/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.playtime;

import de.murmelmeister.murmelapi.playtime.PlayTime;
import de.murmelmeister.murmelapi.playtime.PlayTimeType;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.utils.Database;

public final class PlayTimeProvider
implements PlayTime {
    private static final String TABLE_NAME = "PlayTime";

    public PlayTimeProvider(User user) {
        this.createTable();
        Procedure.loadAll();
        this.loadTables(user);
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (UserID INT PRIMARY KEY, Seconds BIGINT(255), Minutes BIGINT(255), Hours BIGINT(255), Days BIGINT(255), Years BIGINT(255))", TABLE_NAME);
    }

    @Override
    public boolean existsUser(int userId) {
        return Database.exists("CALL %s('%s')", Procedure.PROCEDURE_USER_ID.getName(), userId);
    }

    @Override
    public void createUser(int userId) {
        if (this.existsUser(userId)) {
            return;
        }
        Database.update("CALL %s('%s','%s','%s','%s','%s','%s')", Procedure.PROCEDURE_INSERT.getName(), userId, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public void deleteUser(int userId) {
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_DELETE.getName(), userId);
    }

    @Override
    public long getTime(int userId, PlayTimeType type) {
        String name = switch (type) {
            default -> throw new MatchException(null, null);
            case PlayTimeType.SECONDS -> PlayTimeType.SECONDS.getName();
            case PlayTimeType.MINUTES -> PlayTimeType.MINUTES.getName();
            case PlayTimeType.HOURS -> PlayTimeType.HOURS.getName();
            case PlayTimeType.DAYS -> PlayTimeType.DAYS.getName();
            case PlayTimeType.YEARS -> PlayTimeType.YEARS.getName();
        };
        return Database.getInt(-1, name, "CALL %s('%s')", Procedure.PROCEDURE_USER_ID.getName(), userId);
    }

    @Override
    public void setTime(int userId, PlayTimeType type, long time) {
        String name = switch (type) {
            default -> throw new MatchException(null, null);
            case PlayTimeType.SECONDS -> Procedure.PROCEDURE_UPDATE_SECONDS.getName();
            case PlayTimeType.MINUTES -> Procedure.PROCEDURE_UPDATE_MINUTES.getName();
            case PlayTimeType.HOURS -> Procedure.PROCEDURE_UPDATE_HOURS.getName();
            case PlayTimeType.DAYS -> Procedure.PROCEDURE_UPDATE_DAYS.getName();
            case PlayTimeType.YEARS -> Procedure.PROCEDURE_UPDATE_YEARS.getName();
        };
        Database.update("CALL %s('%s','%s')", name, userId, time);
    }

    @Override
    public void addTime(int userId, PlayTimeType type) {
        long current = this.getTime(userId, type);
        this.setTime(userId, type, ++current);
    }

    @Override
    public void addTime(int userId, PlayTimeType type, long time) {
        long current = this.getTime(userId, type);
        this.setTime(userId, type, current += time);
    }

    @Override
    public void removeTime(int userId, PlayTimeType type) {
        long current = this.getTime(userId, type);
        this.setTime(userId, type, --current);
    }

    @Override
    public void removeTime(int userId, PlayTimeType type, long time) {
        long current = this.getTime(userId, type);
        this.setTime(userId, type, current -= time);
    }

    @Override
    public void resetTime(int userId, PlayTimeType type) {
        this.setTime(userId, type, 0L);
    }

    @Override
    public void timer(int userId) {
        long seconds = this.getTime(userId, PlayTimeType.SECONDS);
        long minutes = this.getTime(userId, PlayTimeType.MINUTES);
        long hours = this.getTime(userId, PlayTimeType.HOURS);
        long days = this.getTime(userId, PlayTimeType.DAYS);
        this.addTime(userId, PlayTimeType.SECONDS);
        if (seconds >= 59L) {
            this.resetTime(userId, PlayTimeType.SECONDS);
            this.addTime(userId, PlayTimeType.MINUTES);
        } else if (minutes >= 59L) {
            this.resetTime(userId, PlayTimeType.MINUTES);
            this.addTime(userId, PlayTimeType.HOURS);
        } else if (hours >= 24L) {
            this.resetTime(userId, PlayTimeType.HOURS);
            this.addTime(userId, PlayTimeType.DAYS);
        } else if (days >= 365L) {
            this.resetTime(userId, PlayTimeType.DAYS);
            this.addTime(userId, PlayTimeType.YEARS);
        }
    }

    private void loadTables(User user) {
        for (Integer userId : user.getIds()) {
            this.createUser(userId);
        }
    }

    private static enum Procedure {
        PROCEDURE_USER_ID("PlayTime_UserID", Database.getProcedureQuery("PlayTime_UserID", "uid INT", "SELECT * FROM %s WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_INSERT("PlayTime_Insert", Database.getProcedureQuery("PlayTime_Insert", "uid INT, sec BIGINT(255), min BIGINT(255), hour BIGINT(255), day BIGINT(255), year BIGINT(255)", "INSERT INTO %s VALUES (uid, sec, min, hour, day, year);", "PlayTime")),
        PROCEDURE_DELETE("PlayTime_Delete", Database.getProcedureQuery("PlayTime_Delete", "uid INT", "DELETE FROM %s WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_UPDATE_SECONDS("PlayTime_Update_Seconds", Database.getProcedureQuery("PlayTime_Update_Seconds", "uid INT, sec BIGINT(255)", "UPDATE %s SET Seconds=sec WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_UPDATE_MINUTES("PlayTime_Update_Minutes", Database.getProcedureQuery("PlayTime_Update_Minutes", "uid INT, min BIGINT(255)", "UPDATE %s SET Minutes=min WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_UPDATE_HOURS("PlayTime_Update_Hours", Database.getProcedureQuery("PlayTime_Update_Hours", "uid INT, hour BIGINT(255)", "UPDATE %s SET Hours=hour WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_UPDATE_DAYS("PlayTime_Update_Days", Database.getProcedureQuery("PlayTime_Update_Days", "uid INT, day BIGINT(255)", "UPDATE %s SET Days=day WHERE UserID=uid;", "PlayTime")),
        PROCEDURE_UPDATE_YEARS("PlayTime_Update_Years", Database.getProcedureQuery("PlayTime_Update_Years", "uid INT, year BIGINT(255)", "UPDATE %s SET Years=year WHERE UserID=uid;", "PlayTime"));

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public static void loadAll() {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

