/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Map<String, ReentrantLock> FILE_LOCKS = new ConcurrentHashMap<String, ReentrantLock>();

    private static ReentrantLock getLockForFile(String fileName) {
        FILE_LOCKS.putIfAbsent(fileName, new ReentrantLock());
        return FILE_LOCKS.get(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createFile(Logger logger, String path, String fileName) {
        ReentrantLock lock = FileUtil.getLockForFile(fileName);
        lock.lock();
        try {
            boolean exist;
            File file = new File(path, fileName);
            File parent = file.getParentFile();
            if (!parent.exists() && !(exist = parent.mkdirs())) {
                logger.warn("Cloud not create the directory: {}", (Object)parent);
            }
            if (!file.exists()) {
                try {
                    exist = file.createNewFile();
                    if (!exist) {
                        logger.error("Cloud not create the file: {}", (Object)file);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            File file2 = file;
            return file2;
        }
        finally {
            lock.unlock();
        }
    }

    public static Properties loadProperties(File file) {
        Properties properties = new Properties(System.getProperties());
        try (FileInputStream stream = new FileInputStream(file);){
            properties.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties from file: " + file.getName(), e);
        }
        return properties;
    }
}

