/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import com.zaxxer.hikari.HikariDataSource;
import de.murmelmeister.murmelapi.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Database {
    private static final HikariDataSource DATA_SOURCE = new HikariDataSource();
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock(true);
    private static final Lock READ_LOCK = LOCK.readLock();
    private static final Lock WRITE_LOCK = LOCK.writeLock();

    public static void connect(String url, String user, String password) {
        WRITE_LOCK.lock();
        try {
            DATA_SOURCE.setJdbcUrl(url);
            DATA_SOURCE.setUsername(user);
            DATA_SOURCE.setPassword(password);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void connect(String driver, String hostname, String port, String database, String username, String password) {
        Database.connect(String.format("jdbc:%s://%s:%s/%s", driver, hostname, port, database), username, password);
    }

    public static void disconnect() {
        WRITE_LOCK.lock();
        try {
            DATA_SOURCE.close();
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void update(String sql, Object ... objects) {
        WRITE_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();){
            PreparedStatement statement = connection.prepareStatement(String.format(sql, objects));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("An error occurred while updating the database.", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void updateCall(String name, Object ... objects) {
        WRITE_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();){
            PreparedStatement statement = connection.prepareStatement(Database.getQueryWithCall(name, objects));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("An error occurred while updating the database.", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void retrieveValuesFromDatabase(List<T> values, Class<T> type, String value, String sql, Object ... objects) throws SQLException {
        READ_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(sql, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                values.add(resultSet.getObject(value, type));
            }
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void retrieveValuesFromDatabaseCall(List<T> values, Class<T> type, String value, String name, Object ... objects) throws SQLException {
        READ_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(Database.getQueryWithCall(name, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                values.add(resultSet.getObject(value, type));
            }
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    public static <T> List<T> getValuesWithDefaultList(List<T> list, Class<T> type, String value, String sql, Object ... objects) {
        List<T> values = Collections.synchronizedList(list);
        try {
            Database.retrieveValuesFromDatabase(values, type, value, sql, objects);
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        return values;
    }

    public static <T> List<T> getValuesWithDefaultListCall(List<T> list, Class<T> type, String value, String name, Object ... objects) {
        List<T> values = Collections.synchronizedList(list);
        try {
            Database.retrieveValuesFromDatabaseCall(values, type, value, name, objects);
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        return values;
    }

    public static <T> List<T> getValues(Class<T> type, String value, String sql, Object ... objects) {
        return Database.getValuesWithDefaultList(new ArrayList(), type, value, sql, objects);
    }

    public static <T> List<T> getValuesCall(Class<T> type, String value, String name, Object ... objects) {
        return Database.getValuesWithDefaultListCall(new ArrayList(), type, value, name, objects);
    }

    public static <T> T getValue(T defaultValue, Class<T> type, String value, String sql, Object ... objects) {
        READ_LOCK.lock();
        T val = defaultValue;
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(sql, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                val = resultSet.getObject(value, type);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        finally {
            READ_LOCK.unlock();
        }
        return val;
    }

    public static <T> T getValueCall(T defaultValue, Class<T> type, String value, String name, Object ... objects) {
        READ_LOCK.lock();
        T val = defaultValue;
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(Database.getQueryWithCall(name, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                val = resultSet.getObject(value, type);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        finally {
            READ_LOCK.unlock();
        }
        return val;
    }

    public static boolean exists(String sql, Object ... objects) {
        READ_LOCK.lock();
        boolean b = false;
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(sql, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                b = true;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        finally {
            READ_LOCK.unlock();
        }
        return b;
    }

    public static boolean existsCall(String name, Object ... objects) {
        READ_LOCK.lock();
        boolean b = false;
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = connection.prepareStatement(Database.getQueryWithCall(name, StringUtil.checkAllObjects(objects)));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                b = true;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Database retrieval error", e);
        }
        finally {
            READ_LOCK.unlock();
        }
        return b;
    }

    public static String getString(String defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(defaultValue, String.class, value, sql, objects);
    }

    public static String getStringCall(String defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(defaultValue, String.class, value, name, objects);
    }

    public static int getInt(int defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(defaultValue, Integer.TYPE, value, sql, objects);
    }

    public static int getIntCall(int defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(defaultValue, Integer.TYPE, value, name, objects);
    }

    public static long getLong(long defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(defaultValue, Long.TYPE, value, sql, objects);
    }

    public static long getLongCall(long defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(defaultValue, Long.TYPE, value, name, objects);
    }

    public static float getFloat(float defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(Float.valueOf(defaultValue), Float.TYPE, value, sql, objects).floatValue();
    }

    public static float getFloatCall(float defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(Float.valueOf(defaultValue), Float.TYPE, value, name, objects).floatValue();
    }

    public static double getDouble(double defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(defaultValue, Double.TYPE, value, sql, objects);
    }

    public static double getDoubleCall(double defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(defaultValue, Double.TYPE, value, name, objects);
    }

    public static UUID getUniqueId(UUID defaultValue, String value, String sql, Object ... objects) {
        return Database.getValue(defaultValue, UUID.class, value, sql, objects);
    }

    public static UUID getUniqueIdCall(UUID defaultValue, String value, String name, Object ... objects) {
        return Database.getValueCall(defaultValue, UUID.class, value, name, objects);
    }

    public static List<String> getStringList(String value, String sql, Object ... objects) {
        return Database.getValues(String.class, value, sql, objects);
    }

    public static List<String> getStringListCall(String value, String name, Object ... objects) {
        return Database.getValuesCall(String.class, value, name, objects);
    }

    public static List<Integer> getIntList(String value, String sql, Object ... objects) {
        return Database.getValues(Integer.TYPE, value, sql, objects);
    }

    public static List<Integer> getIntListCall(String value, String name, Object ... objects) {
        return Database.getValuesCall(Integer.TYPE, value, name, objects);
    }

    public static List<UUID> getUniqueIdList(String value, String sql, Object ... objects) {
        return Database.getValues(UUID.class, value, sql, objects);
    }

    public static List<UUID> getUniqueIdListCall(String value, String name, Object ... objects) {
        return Database.getValuesCall(UUID.class, value, name, objects);
    }

    public static String getProcedureQuery(String name, String input, String query, Object ... objects) {
        return String.format("CREATE PROCEDURE IF NOT EXISTS %s(%s)\nBEGIN\n    %s\nEND;", name, input, String.format(query, objects));
    }

    private static String getQueryWithCall(String name, Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("'").append(objects[i]).append("'");
        }
        String finalSql = builder.toString();
        return String.format("CALL %s(%s)", name, finalSql);
    }
}

