/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.parent;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;

public final class GroupParentProvider
implements GroupParent {
    private static final String TABLE_NAME = "GroupParent";

    public GroupParentProvider() {
        this.createTable();
        Procedure.loadAll();
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (GroupID INT, CreatorID INT, ParentID INT, CreatedTime BIGINT(255), ExpiredTime BIGINT(255))", TABLE_NAME);
    }

    @Override
    public boolean existsParent(int groupId, int parentId) {
        return Database.exists("CALL %s('%s','%s')", Procedure.PROCEDURE_PARENT.getName(), groupId, parentId);
    }

    @Override
    public void addParent(int groupId, int creatorId, int parentId, long time) {
        if (this.existsParent(groupId, parentId)) {
            return;
        }
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.update("CALL %s('%s','%s','%s','%s','%s')", Procedure.PROCEDURE_ADD.getName(), groupId, creatorId, parentId, System.currentTimeMillis(), expired);
    }

    @Override
    public void removeParent(int groupId, int parentId) {
        Database.update("CALL %s('%s','%s')", Procedure.PROCEDURE_REMOVE.getName(), groupId, parentId);
    }

    @Override
    public void clearParent(int groupId) {
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_CLEAR.getName(), groupId);
    }

    @Override
    public List<Integer> getParentIds(int groupId) {
        return Database.getIntList("ParentID", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public List<String> getParentNames(Group group, int groupId) {
        return this.getParentIds(groupId).parallelStream().map(group::getName).collect(Collectors.toList());
    }

    @Override
    public int getCreatorId(int groupId, int parentId) {
        return Database.getInt(-2, "CreatorID", "CALL %s('%s','%s')", Procedure.PROCEDURE_PARENT.getName(), groupId, parentId);
    }

    @Override
    public long getCreatedTime(int groupId, int parentId) {
        return Database.getLong(-1L, "CreatedTime", "CALL %s('%s','%s')", Procedure.PROCEDURE_PARENT.getName(), groupId, parentId);
    }

    @Override
    public String getCreatedDate(int groupId, int parentId) {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.getCreatedTime(groupId, parentId));
    }

    @Override
    public long getExpiredTime(int groupId, int parentId) {
        return Database.getLong(-2L, "ExpiredTime", "CALL %s('%s','%s')", Procedure.PROCEDURE_PARENT.getName(), groupId, parentId);
    }

    @Override
    public String getExpiredDate(int groupId, int parentId) {
        long time = this.getExpiredTime(groupId, parentId);
        return time == -1L ? "never" : new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(time);
    }

    @Override
    public String setExpiredTime(int groupId, int parentId, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public String addExpiredTime(int groupId, int parentId, long time) {
        long current = this.getExpiredTime(groupId, parentId);
        long expired = current == -1L ? System.currentTimeMillis() + time : current + time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public String removeExpiredTime(int groupId, int parentId, long time) {
        long current = this.getExpiredTime(groupId, parentId);
        long expired = current == -1L ? System.currentTimeMillis() : current - time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public void loadExpired(Group group) {
        for (Integer groupId : group.getUniqueIds()) {
            for (Integer parentId : this.getParentIds(groupId)) {
                long time = this.getExpiredTime(groupId, parentId);
                if (time == -1L || time > System.currentTimeMillis()) continue;
                this.removeParent(groupId, parentId);
            }
        }
    }

    private static enum Procedure {
        PROCEDURE_GROUP_ID("GroupParent_GroupID", Database.getProcedureQuery("GroupParent_GroupID", "gid INT", "SELECT * FROM %s WHERE GroupID=gid;", "GroupParent")),
        PROCEDURE_PARENT("GroupParent_Parent", Database.getProcedureQuery("GroupParent_Parent", "gid INT, pid INT", "SELECT * FROM %s WHERE GroupID=gid AND ParentID=pid;", "GroupParent")),
        PROCEDURE_ADD("GroupParent_Add", Database.getProcedureQuery("GroupParent_Add", "gid INT, creator INT, pid INT, created BIGINT(255), expired BIGINT(255)", "INSERT INTO %s VALUES (gid, creator, pid, created, expired);", "GroupParent")),
        PROCEDURE_REMOVE("GroupParent_Remove", Database.getProcedureQuery("GroupParent_Remove", "gid INT, pid INT", "DELETE FROM %s WHERE GroupID=gid AND ParentID=pid;", "GroupParent")),
        PROCEDURE_CLEAR("GroupParent_Clear", Database.getProcedureQuery("GroupParent_Clear", "gid INT", "DELETE FROM %s WHERE GroupID=gid;", "GroupParent")),
        PROCEDURE_EXPIRED("GroupParent_Expired", Database.getProcedureQuery("GroupParent_Expired", "gid INT, pid INT, expired BIGINT(255)", "UPDATE %s SET ExpiredTime=expired WHERE GroupID=gid AND ParentID=pid;", "GroupParent"));

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public static void loadAll() {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

