/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.time;

import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.time.PlayTime;
import de.murmelmeister.murmelapi.time.PlayTimeType;

public final class PlayTimeProvider
implements PlayTime {
    private static final String TABLE_NAME = "PlayTime";
    private final Database database;

    public PlayTimeProvider(Database database) {
        this.database = database;
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "UserID INT PRIMARY KEY, FOREIGN KEY (UserID) REFERENCES Users(ID), Seconds INT");
        Procedure.loadAll(database);
    }

    @Override
    public boolean existsUser(int userId) {
        return this.database.exists(Procedure.GET_SECONDS.getName(), userId);
    }

    @Override
    public void createUser(int userId) {
        this.database.callUpdate(Procedure.CREATE.getName(), userId, 0);
    }

    @Override
    public void deleteUser(int userId) {
        this.database.callUpdate(Procedure.DELETE.getName(), userId);
    }

    @Override
    public int getTime(int userId) {
        return this.database.query(-1, "Seconds", Integer.TYPE, Procedure.GET_SECONDS.getName(), userId);
    }

    @Override
    public void setTime(int userId, int time) {
        this.database.callUpdate(Procedure.UPDATE_SECONDS.getName(), time, userId);
    }

    @Override
    public void addTime(int userId) {
        int current = this.getTime(userId);
        this.setTime(userId, ++current);
    }

    @Override
    public void addTime(int userId, PlayTimeType type, int time) {
        int current = this.getTime(userId);
        this.setTime(userId, current += type.toSeconds(time));
    }

    @Override
    public void removeTime(int userId) {
        int current = this.getTime(userId);
        this.setTime(userId, --current);
    }

    @Override
    public void removeTime(int userId, PlayTimeType type, int time) {
        int current = this.getTime(userId);
        this.setTime(userId, current -= type.toSeconds(time));
    }

    @Override
    public void resetTime(int userId) {
        this.setTime(userId, 0);
    }

    private static enum Procedure {
        CREATE("PlayTime_Create", "uid INT, sec INT", "INSERT INTO [TABLE] VALUES (uid, sec);"),
        DELETE("PlayTime_Delete", "uid INT", "DELETE FROM [TABLE] WHERE UserID=uid;"),
        GET_SECONDS("PlayTime_GetSeconds", "uid INT", "SELECT Seconds FROM [TABLE] WHERE UserID=uid;"),
        UPDATE_SECONDS("PlayTime_UpdateSeconds", "sec INT, uid INT", "UPDATE [TABLE] SET Seconds=sec WHERE UserID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", PlayTimeProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

