/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.murmelmeister.murmelapi.exceptions.DatabaseException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Database {
    private final Logger logger = LoggerFactory.getLogger(Database.class);
    private HikariDataSource dataSource;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.lock.writeLock();

    private HikariConfig getHikariConfig(String driverClassName, String url, String user, String password) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(driverClassName);
        config.setJdbcUrl(url);
        config.setUsername(user);
        config.setPassword(password);
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(60000L);
        config.setMaxLifetime(1800000L);
        return config;
    }

    public void connect(String url, String user, String password) {
        try {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
            }
            HikariConfig config = this.getHikariConfig("com.mysql.cj.jdbc.Driver", url, user, password);
            this.dataSource = new HikariDataSource(config);
        }
        catch (Exception e) {
            this.logger.error("Error connecting to database", (Throwable)e);
            throw new DatabaseException("Database connecting error", e);
        }
    }

    public void connect(String driver, String hostname, String port, String database, String username, String password) {
        this.connect(String.format("jdbc:%s://%s:%s/%s", driver, hostname, port, database), username, password);
    }

    public void disconnect() {
        try {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error closing the database", (Throwable)e);
            throw new DatabaseException("Database closing error", e);
        }
    }

    public void update(String sql, Object ... objects) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = this.getPreparedStatement(connection, sql, objects);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("Error executing update: {}", (Object)sql, (Object)e);
            throw new DatabaseException("Database updating error", e);
        }
    }

    public void callUpdate(String name, Object ... objects) {
        try (Connection connection = this.dataSource.getConnection();
             CallableStatement statement = this.getCallableStatement(connection, name, objects);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("Error executing callUpdate: {}", (Object)name, (Object)e);
            throw new DatabaseException("Database calling update error", e);
        }
    }

    public void createTable(String tableName, String value) {
        this.update("CREATE TABLE IF NOT EXISTS " + tableName + " (" + value + ")", new Object[0]);
    }

    public <T> T query(T defaultValue, String label, Class<T> type, String name, Object ... objects) {
        T value = defaultValue;
        try (Connection connection = this.dataSource.getConnection();
             CallableStatement statement = this.getCallableStatement(connection, name, objects);
             ResultSet resultSet = statement.executeQuery();){
            if (resultSet.next()) {
                value = resultSet.getObject(label, type);
            }
        }
        catch (SQLException e) {
            this.logger.error("Error executing query: {}", (Object)name, (Object)e);
            throw new DatabaseException("Database query error", e);
        }
        return value;
    }

    public <T> List<T> queryList(List<T> defaultList, String label, Class<T> type, String name, Object ... objects) {
        try (Connection connection = this.dataSource.getConnection();
             CallableStatement statement = this.getCallableStatement(connection, name, objects);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                defaultList.add(resultSet.getObject(label, type));
            }
        }
        catch (SQLException e) {
            this.logger.error("Error executing queryList: {}", (Object)name, (Object)e);
            throw new DatabaseException("Database query error", e);
        }
        return defaultList;
    }

    public <V> Map<String, V> queryMap(Map<String, V> defaultMap, Class<V> valueType, String name, Object ... objects) {
        try (Connection connection = this.dataSource.getConnection();
             CallableStatement statement = this.getCallableStatement(connection, name, objects);
             ResultSet resultSet = statement.executeQuery();){
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    defaultMap.put(metaData.getColumnLabel(i), resultSet.getObject(i, valueType));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Error executing queryMap: {}", (Object)name, (Object)e);
            throw new DatabaseException("Database query error", e);
        }
        return defaultMap;
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String name, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public UUID generateUniqueIdentifier(String name) {
        UUID uuid;
        do {
            uuid = UUID.randomUUID();
        } while (this.exists(name, uuid.toString()));
        return uuid;
    }

    public static String getProcedureQuery(String name, String input, String query) {
        return "CREATE PROCEDURE IF NOT EXISTS " + name + "(" + input + ")\nBEGIN\n    " + query + "\nEND;";
    }

    private CallableStatement getCallableStatement(Connection connection, String name, Object ... objects) throws SQLException {
        String placeholder = objects.length > 0 ? String.join((CharSequence)",", Collections.nCopies(objects.length, "?")) : "";
        CallableStatement statement = connection.prepareCall("{CALL " + name + "(" + placeholder + ")}");
        this.setParameters(statement, objects);
        return statement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String query, Object ... objects) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(query);
        this.setParameters(statement, objects);
        return statement;
    }

    private void setParameters(PreparedStatement statement, Object ... objects) throws SQLException {
        block18: for (int i = 0; i < objects.length; ++i) {
            Object object;
            int parameterIndex = i + 1;
            Object object2 = objects[i];
            if (object2 == null) {
                statement.setNull(parameterIndex, 0);
                continue;
            }
            Objects.requireNonNull(object2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, String.class, byte[].class, Date.class, Time.class, Timestamp.class, Array.class, URL.class, UUID.class}, (Object)object, n)) {
                case 0: {
                    Boolean value = (Boolean)object;
                    statement.setBoolean(parameterIndex, value);
                    continue block18;
                }
                case 1: {
                    Byte value = (Byte)object;
                    statement.setByte(parameterIndex, value);
                    continue block18;
                }
                case 2: {
                    Short value = (Short)object;
                    statement.setShort(parameterIndex, value);
                    continue block18;
                }
                case 3: {
                    Integer value = (Integer)object;
                    statement.setInt(parameterIndex, value);
                    continue block18;
                }
                case 4: {
                    Long value = (Long)object;
                    statement.setLong(parameterIndex, value);
                    continue block18;
                }
                case 5: {
                    Float value = (Float)object;
                    statement.setFloat(parameterIndex, value.floatValue());
                    continue block18;
                }
                case 6: {
                    Double value = (Double)object;
                    statement.setDouble(parameterIndex, value);
                    continue block18;
                }
                case 7: {
                    BigDecimal value = (BigDecimal)object;
                    statement.setBigDecimal(parameterIndex, value);
                    continue block18;
                }
                case 8: {
                    String value = (String)object;
                    statement.setString(parameterIndex, value);
                    continue block18;
                }
                case 9: {
                    byte[] value = (byte[])object;
                    statement.setBytes(parameterIndex, value);
                    continue block18;
                }
                case 10: {
                    Date value = (Date)object;
                    statement.setDate(parameterIndex, value);
                    continue block18;
                }
                case 11: {
                    Time value = (Time)object;
                    statement.setTime(parameterIndex, value);
                    continue block18;
                }
                case 12: {
                    Timestamp value = (Timestamp)object;
                    statement.setTimestamp(parameterIndex, value);
                    continue block18;
                }
                case 13: {
                    Array value = (Array)object;
                    statement.setArray(parameterIndex, value);
                    continue block18;
                }
                case 14: {
                    URL value = (URL)object;
                    statement.setURL(parameterIndex, value);
                    continue block18;
                }
                case 15: {
                    UUID value = (UUID)object;
                    statement.setString(parameterIndex, value.toString());
                    continue block18;
                }
                default: {
                    statement.setObject(parameterIndex, object2);
                }
            }
        }
    }
}

