/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.parent.UserParent;
import de.murmelmeister.murmelapi.user.parent.UserParentProvider;
import de.murmelmeister.murmelapi.user.permission.UserPermission;
import de.murmelmeister.murmelapi.user.permission.UserPermissionProvider;
import de.murmelmeister.murmelapi.utils.CacheManager;
import de.murmelmeister.murmelapi.utils.MojangUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class UserProvider
implements User {
    private static final String TABLE_NAME = "Users";
    private final Database database;
    private final CacheManager<String, Integer> usernameCache = new CacheManager();
    private final CacheManager<UUID, Integer> uuidCache = new CacheManager();
    private UserParent parent;
    private UserPermission permission;

    public UserProvider(Database database) {
        this.database = database;
        this.parent = this.getParent();
        this.permission = this.getPermission();
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "ID INT PRIMARY KEY AUTO_INCREMENT, MojangID UUID UNIQUE, Username VARCHAR(100), FirstJoinTime DATETIME");
        Procedure.loadAll(database);
        UserProvider.createConsoleUser(database);
    }

    private static void createConsoleUser(Database database) {
        int id = -1;
        if (database.exists(Procedure.USERS_GET_ALL_BY_ID.getName(), id)) {
            return;
        }
        database.callUpdate(Procedure.USERS_CREATE_CONSOLE.getName(), id);
    }

    @Override
    public int createOrGetUser(String username) {
        int id = this.getId(username);
        if (id != -2) {
            return id;
        }
        try {
            UUID uuid = MojangUtils.getUUID(username);
            this.createUser(uuid, username);
            return this.getId(uuid);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Couldn't find any profile with username: " + username);
        }
    }

    @Override
    public int createOrGetUser(UUID uuid) {
        int id = this.getId(uuid);
        if (id != -2) {
            return id;
        }
        try {
            String username = MojangUtils.getUsername(uuid);
            this.createUser(uuid, username);
            return this.getId(uuid);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Couldn't find any profile with uuid: " + String.valueOf(uuid));
        }
    }

    @Override
    public boolean existsUser(UUID uuid) {
        return this.database.exists(Procedure.USERS_GET_ALL_BY_UUID.getName(), uuid.toString());
    }

    @Override
    public boolean existsUser(String username) {
        return this.database.exists(Procedure.USERS_GET_ALL_BY_USERNAME.getName(), username);
    }

    @Override
    public void createUser(UUID uuid, String username) {
        this.database.callUpdate(Procedure.USERS_CREATE.getName(), uuid.toString(), username);
    }

    @Override
    public void deleteUser(UUID uuid) {
        String username = this.getUsername(uuid);
        this.database.update(Procedure.USERS_DELETE.getName(), uuid.toString());
        if (username != null) {
            this.usernameCache.remove(username);
        }
        if (this.uuidCache.get(uuid) != null) {
            this.uuidCache.remove(uuid);
        }
    }

    @Override
    public int getId(UUID uuid) {
        Integer id = this.uuidCache.get(uuid);
        if (id == null && (id = Integer.valueOf(this.loadIdByUUID(uuid))) != -2) {
            this.uuidCache.put(uuid, id, 1L, TimeUnit.HOURS);
        }
        return id;
    }

    @Override
    public int getId(String username) {
        Integer id = this.usernameCache.get(username);
        if (id == null && (id = Integer.valueOf(this.loadIdByUsername(username))) != -2) {
            this.usernameCache.put(username, id, 1L, TimeUnit.HOURS);
        }
        return id;
    }

    private int loadIdByUUID(UUID uuid) {
        return this.database.query(-2, "ID", Integer.TYPE, Procedure.USERS_GET_ALL_BY_UUID.getName(), uuid.toString());
    }

    private int loadIdByUsername(String username) {
        return this.database.query(-2, "ID", Integer.TYPE, Procedure.USERS_GET_ALL_BY_USERNAME.getName(), username);
    }

    @Override
    public UUID getUniqueId(int userId) {
        return userId == -1 ? null : UUID.fromString(this.database.query(null, "MojangID", String.class, Procedure.USERS_GET_ALL_BY_ID.getName(), userId));
    }

    @Override
    public UUID getUniqueId(String username) {
        int id = this.getId(username);
        return UUID.fromString(this.database.query(null, "MojangID", String.class, Procedure.USERS_GET_ALL_BY_ID.getName(), id));
    }

    @Override
    public String getUsername(int userId) {
        return userId == -1 ? "CONSOLE" : this.database.query(null, "Username", String.class, Procedure.USERS_GET_ALL_BY_ID.getName(), userId);
    }

    @Override
    public String getUsername(UUID uuid) {
        int id = this.getId(uuid);
        return id == -1 ? "CONSOLE" : this.database.query(null, "Username", String.class, Procedure.USERS_GET_ALL_BY_ID.getName(), id);
    }

    @Override
    public void rename(int userId, String newUsername) {
        this.database.callUpdate(Procedure.USERS_RENAME.getName(), newUsername, userId);
    }

    @Override
    public void rename(UUID uuid, String newUsername) {
        int id = this.getId(uuid);
        this.database.callUpdate(Procedure.USERS_RENAME.getName(), newUsername, id);
    }

    @Override
    public List<UUID> getUniqueIds() {
        return this.database.queryList(new LinkedList(), "MojangID", String.class, Procedure.USERS_GET_ALL.getName(), new Object[0]).parallelStream().filter(Objects::nonNull).map(UUID::fromString).toList();
    }

    @Override
    public List<String> getUsernames() {
        return this.database.queryList(new LinkedList(), "Username", String.class, Procedure.USERS_GET_ALL.getName(), new Object[0]).parallelStream().filter(Objects::nonNull).toList();
    }

    @Override
    public Timestamp getFirstJoinTime(int userId) {
        return this.database.query(null, "FirstJoinTime", Timestamp.class, Procedure.USERS_GET_ALL_BY_ID.getName(), userId);
    }

    @Override
    public String getFirstJoinDate(int userId) {
        Timestamp time = this.getFirstJoinTime(userId);
        return time == null ? "never" : MurmelAPI.getDateFormat().format(time);
    }

    @Override
    public void setFirstJoinTime(int userId) {
        if (this.getFirstJoinTime(userId) != null) {
            return;
        }
        this.database.callUpdate(Procedure.USERS_SET_FIRST_JOIN.getName(), userId, new Timestamp(System.currentTimeMillis()).toString());
    }

    @Override
    public void joinUser(UUID uuid, String username) {
        int id = this.getId(uuid);
        if (id == -2) {
            this.createUser(uuid, username);
            id = this.getId(uuid);
        }
        if (!this.getUsername(id).equals(username)) {
            this.rename(id, username);
        }
    }

    @Override
    public void loadExpired() {
        this.parent.loadExpired(this);
        this.permission.loadExpired(this);
    }

    @Override
    public UserParent getParent() {
        if (this.parent == null) {
            this.parent = new UserParentProvider(this.database);
        }
        return this.parent;
    }

    @Override
    public UserPermission getPermission() {
        if (this.permission == null) {
            this.permission = new UserPermissionProvider(this.database);
        }
        return this.permission;
    }

    private static enum Procedure {
        USERS_GET_ALL_BY_UUID("Users_GetAllByUUID", "uid UUID", "SELECT ID FROM [TABLE] WHERE MojangID=uid;"),
        USERS_GET_ALL_BY_USERNAME("Users_GetAllByUsername", "uname VARCHAR(100)", "SELECT ID FROM [TABLE] WHERE Username=uname;"),
        USERS_GET_ALL_BY_ID("Users_GetAllById", "uid INT", "SELECT * FROM [TABLE] WHERE ID=uid;"),
        USERS_GET_ALL_BY_IP("Users_GetAllByIP", "ip INET6", "SELECT * FROM [TABLE] WHERE IPAddress=ip;"),
        USERS_GET_ALL("Users_GetAll", "", "SELECT ID, MojangID, Username FROM [TABLE];"),
        USERS_CREATE("Users_Create", "uid UUID, uname VARCHAR(100)", "INSERT INTO [TABLE] (MojangID,Username) VALUES (uid,uname);"),
        USERS_DELETE("Users_Delete", "uid UUID", "DELETE FROM [TABLE] WHERE MojangID=uid;"),
        USERS_RENAME("Users_Rename", "uname VARCHAR(100), uid INT", "UPDATE [TABLE] SET Username=uname WHERE ID=uid;"),
        USERS_SET_FIRST_JOIN("Users_SetFirstJoin", "uid INT, time DATETIME", "UPDATE [TABLE] SET FirstJoinTime=time WHERE ID=uid;"),
        USERS_CREATE_CONSOLE("Users_CreateConsole", "uid INT", "INSERT INTO [TABLE] (ID) VALUES (uid);");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", UserProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

