/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.library.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.murmelmeister.library.database.ParameterProcessor;
import de.murmelmeister.library.database.ResultSetProcessor;
import de.murmelmeister.library.exceptions.DatabaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Database
implements AutoCloseable {
    private static final long SLOW_QUERY_THRESHOLD_MS = 500L;
    private static final int EXECUTOR_POOL_SIZE = 10;
    private static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z0-9_]+");
    private static final ThreadFactory WORKER_THREAD_FACTORY = new DaemonThreadFactory("database-worker-");
    private static final ThreadFactory NETWORK_TIMEOUT_THREAD_FACTORY = new DaemonThreadFactory("database-network-timeout-");
    private final Logger logger = LoggerFactory.getLogger(Database.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile ExecutorService executor;
    private volatile ExecutorService networkTimeoutExecutor;
    private volatile HikariDataSource dataSource;
    private volatile Integer transactionIsolationLevel;

    public void connect(HikariConfig config) {
        try {
            if (!this.lock.writeLock().tryLock(10L, TimeUnit.SECONDS)) {
                throw new DatabaseException("Failed to acquire write lock for database connection setup. Another thread is currently configuring the database connection.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DatabaseException("Interrupted while waiting for write lock to connect to the database", e);
        }
        try {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
            }
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = this.createExecutor();
            }
            if (this.networkTimeoutExecutor == null || this.networkTimeoutExecutor.isShutdown()) {
                this.networkTimeoutExecutor = this.createNetworkTimeoutExecutor();
            }
            this.dataSource = new HikariDataSource(config);
            this.logger.info("Database connection established successfully. URL: {}", (Object)this.dataSource.getJdbcUrl());
        }
        catch (Exception e) {
            this.shutdownExecutor(this.executor);
            this.executor = null;
            this.shutdownExecutor(this.networkTimeoutExecutor);
            this.networkTimeoutExecutor = null;
            this.closeDataSourceQuietly(this.dataSource);
            this.dataSource = null;
            throw new DatabaseException("Failed to connect to the database", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void connect(String propertyFileName) {
        HikariConfig config = new HikariConfig(propertyFileName);
        this.connect(config);
    }

    public void connect(Properties properties) {
        HikariConfig config = new HikariConfig(properties);
        this.connect(config);
    }

    public void connect(String url, String username, String password) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setUsername(username);
        config.setPassword(password);
        this.connect(config);
    }

    public void setTransactionIsolationLevel(Integer isolationLevel) {
        this.transactionIsolationLevel = isolationLevel == null ? null : Integer.valueOf(this.normalizeIsolationLevel(isolationLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ExecutorService networkExecutorToShutdown;
        ExecutorService executorToShutdown;
        HikariDataSource dataSourceToClose;
        try {
            if (!this.lock.writeLock().tryLock(10L, TimeUnit.SECONDS)) {
                throw new DatabaseException("Failed to acquire write lock for database disconnection. Another thread is currently using the database connection.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DatabaseException("Interrupted while waiting for write lock to disconnect from the database", e);
        }
        try {
            dataSourceToClose = this.dataSource;
            this.dataSource = null;
            executorToShutdown = this.executor;
            this.executor = null;
            networkExecutorToShutdown = this.networkTimeoutExecutor;
            this.networkTimeoutExecutor = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.shutdownExecutor(executorToShutdown);
        this.shutdownExecutor(networkExecutorToShutdown);
        if (dataSourceToClose != null) {
            try {
                if (!dataSourceToClose.isClosed()) {
                    dataSourceToClose.close();
                }
                this.logger.info("Database connection closed successfully");
            }
            catch (Exception e) {
                throw new DatabaseException("Failed to close the database connection", e);
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    /*
     * Exception decompiling
     */
    public <T> T query(String sql, T fallback, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> T queryCallable(String sql, T fallback, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> CompletableFuture<T> queryAsync(String sql, T fallback, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.query(sql, fallback, processor, parameters), asyncExecutor);
    }

    public <T> CompletableFuture<T> queryCallableAsync(String sql, T fallback, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.queryCallable(sql, fallback, processor, parameters), asyncExecutor);
    }

    /*
     * Exception decompiling
     */
    public <T> List<T> queryList(String sql, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> List<T> queryListCallable(String sql, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> CompletableFuture<List<T>> queryListAsync(String sql, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.queryList(sql, processor, parameters), asyncExecutor);
    }

    public <T> CompletableFuture<List<T>> queryListCallableAsync(String sql, ResultSetProcessor<T> processor, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.queryListCallable(sql, processor, parameters), asyncExecutor);
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String sql, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean existsCallable(String sql, ParameterProcessor parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompletableFuture<Boolean> existsAsync(String sql, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.exists(sql, parameters), asyncExecutor);
    }

    public CompletableFuture<Boolean> existsCallableAsync(String sql, ParameterProcessor parameters) {
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> this.existsCallable(sql, parameters), asyncExecutor);
    }

    public CompletableFuture<Long> getAutoIncrement(String tableName) {
        if (!NAME_PATTERN.matcher(tableName).matches()) {
            throw new DatabaseException("Invalid table name: " + tableName);
        }
        String sql = "SHOW TABLE STATUS LIKE ?";
        ExecutorService asyncExecutor = this.requireExecutor();
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, asyncExecutor);
    }

    public int update(String sql, ParameterProcessor parameters) {
        return this.executeInTransaction(connection -> {
            try (PreparedStatement statement = this.getPreparedStatement(connection, sql, parameters);){
                Integer n = statement.executeUpdate();
                return n;
            }
        });
    }

    public int update(String sql) {
        return this.update(sql, ParameterProcessor.noop());
    }

    public long updateAndGetGeneratedKeys(String sql, ParameterProcessor parameters) {
        return this.executeInTransaction(connection -> {
            try (PreparedStatement statement = this.getGeneratedKeysStatement(connection, sql, parameters);){
                int affectedRows = statement.executeUpdate();
                if (affectedRows > 0) {
                    try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                        if (generatedKeys.next()) {
                            Long l = generatedKeys.getLong(1);
                            return l;
                        }
                    }
                }
                Long l = 0L;
                return l;
            }
        });
    }

    public int updateCallable(String sql, ParameterProcessor parameters) {
        return this.executeInTransaction(connection -> {
            try (CallableStatement statement = this.getCallableStatement(connection, sql, parameters);){
                Integer n = statement.executeUpdate();
                return n;
            }
        });
    }

    public int[] updateBatch(String sql, ParameterProcessor parameters) {
        return this.executeInTransaction(connection -> {
            try (PreparedStatement statement = this.getBatchStatement(connection, sql, parameters);){
                int[] nArray = statement.executeBatch();
                return nArray;
            }
        });
    }

    public int createTable(String name, String columns) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new DatabaseException("Invalid table name: " + name);
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + name + "(" + columns + ")";
        return this.update(sql);
    }

    public void runSqlScript(Path scriptPath) {
        Objects.requireNonNull(scriptPath, "scriptPath");
        try (BufferedReader reader = Files.newBufferedReader(scriptPath, StandardCharsets.UTF_8);){
            this.runSqlScript(reader);
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to read SQL script from " + String.valueOf(scriptPath), e);
        }
    }

    public void runSqlScript(Reader scriptReader) {
        Objects.requireNonNull(scriptReader, "scriptReader");
        this.executeInTransaction(connection -> {
            try (BufferedReader reader = scriptReader instanceof BufferedReader ? (BufferedReader)scriptReader : new BufferedReader(scriptReader);){
                Object var11_17;
                block23: {
                    Statement statement = connection.createStatement();
                    try {
                        String line;
                        StringBuilder buffer = new StringBuilder();
                        boolean inSingleQuote = false;
                        boolean inDoubleQuote = false;
                        boolean inBlockComment = false;
                        boolean escape = false;
                        while ((line = reader.readLine()) != null) {
                            int length = line.length();
                            for (int i = 0; i < length; ++i) {
                                char current = line.charAt(i);
                                if (!inSingleQuote && !inDoubleQuote) {
                                    if (inBlockComment) {
                                        if (current != '*' || i + 1 >= length || line.charAt(i + 1) != '/') continue;
                                        inBlockComment = false;
                                        ++i;
                                        continue;
                                    }
                                    if (current == '-' && i + 1 < length && line.charAt(i + 1) == '-') break;
                                    if (current == '/' && i + 1 < length && line.charAt(i + 1) == '*') {
                                        inBlockComment = true;
                                        ++i;
                                        continue;
                                    }
                                }
                                if (!inDoubleQuote && current == '\'' && !escape) {
                                    inSingleQuote = !inSingleQuote;
                                } else if (!inSingleQuote && current == '\"' && !escape) {
                                    boolean bl = inDoubleQuote = !inDoubleQuote;
                                }
                                if (current == ';' && !inSingleQuote && !inDoubleQuote) {
                                    this.executeSqlStatement(statement, buffer);
                                    buffer.setLength(0);
                                    escape = false;
                                    continue;
                                }
                                buffer.append(current);
                                escape = current == '\\' && !escape;
                            }
                            buffer.append('\n');
                            escape = false;
                        }
                        this.executeSqlStatement(statement, buffer);
                        var11_17 = null;
                        if (statement == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return var11_17;
            }
            catch (IOException e) {
                throw new DatabaseException("Failed to read SQL script", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeInTransaction(ConnectionOperation<T> operation) {
        long startTime = System.nanoTime();
        Connection connection = null;
        boolean previousAutoCommit = true;
        int previousIsolation = 2;
        boolean previousReadOnly = false;
        ExecutorService timeoutExecutor = this.requireNetworkTimeoutExecutor();
        HikariDataSource currentDataSource = this.requireDataSource();
        Integer desiredIsolation = this.transactionIsolationLevel;
        if (desiredIsolation != null) {
            desiredIsolation = this.normalizeIsolationLevel(desiredIsolation);
        }
        try {
            connection = currentDataSource.getConnection();
            previousAutoCommit = connection.getAutoCommit();
            previousIsolation = connection.getTransactionIsolation();
            previousReadOnly = connection.isReadOnly();
            if (previousAutoCommit) {
                connection.setAutoCommit(false);
            }
            if (desiredIsolation != null && previousIsolation != desiredIsolation) {
                connection.setTransactionIsolation(desiredIsolation);
            }
            connection.setReadOnly(false);
            connection.setNetworkTimeout(timeoutExecutor, 30000);
            T result = operation.execute(connection);
            connection.commit();
            T t = result;
            return t;
        }
        catch (RuntimeException | SQLException e) {
            if (connection == null) throw new DatabaseException("Failed to execute transaction.", e);
            try {
                if (connection.getAutoCommit()) throw new DatabaseException("Failed to execute transaction.", e);
                connection.rollback();
                throw new DatabaseException("Failed to execute transaction.", e);
            }
            catch (SQLException rollbackException) {
                this.logger.error("Failed to roll back transaction", (Throwable)rollbackException);
            }
            throw new DatabaseException("Failed to execute transaction.", e);
        }
        finally {
            long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (durationMs > 500L) {
                this.logger.warn("Slow database operation executed in {} ms", (Object)durationMs);
            }
            if (connection != null) {
                try {
                    if (connection.getAutoCommit() != previousAutoCommit) {
                        connection.setAutoCommit(previousAutoCommit);
                    }
                    if (connection.getTransactionIsolation() != previousIsolation) {
                        connection.setTransactionIsolation(previousIsolation);
                    }
                    connection.setReadOnly(previousReadOnly);
                    connection.setNetworkTimeout(timeoutExecutor, 0);
                }
                catch (SQLException e) {
                    this.logger.error("Failed to restore connection state", (Throwable)e);
                }
                finally {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("Failed to close database connection", (Throwable)e);
                    }
                }
            }
        }
    }

    private CallableStatement getCallableStatement(Connection connection, String sql, ParameterProcessor parameters) throws SQLException {
        CallableStatement statement = connection.prepareCall(sql);
        ParameterProcessor.of(parameters).execute(statement);
        return statement;
    }

    private PreparedStatement getBatchStatement(Connection connection, String sql, ParameterProcessor parameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        ParameterProcessor.of(parameters).execute(statement);
        return statement;
    }

    private PreparedStatement getGeneratedKeysStatement(Connection connection, String sql, ParameterProcessor parameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql, 1);
        ParameterProcessor.of(parameters).execute(statement);
        return statement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String sql, ParameterProcessor parameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        ParameterProcessor.of(parameters).execute(statement);
        return statement;
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(10, WORKER_THREAD_FACTORY);
    }

    private ExecutorService createNetworkTimeoutExecutor() {
        return Executors.newCachedThreadPool(NETWORK_TIMEOUT_THREAD_FACTORY);
    }

    private ExecutorService requireExecutor() {
        ExecutorService currentExecutor = this.executor;
        if (currentExecutor == null || currentExecutor.isShutdown()) {
            throw new DatabaseException("Database is not connected");
        }
        return currentExecutor;
    }

    private ExecutorService requireNetworkTimeoutExecutor() {
        ExecutorService currentExecutor = this.networkTimeoutExecutor;
        if (currentExecutor == null || currentExecutor.isShutdown()) {
            throw new DatabaseException("Database is not connected");
        }
        return currentExecutor;
    }

    private HikariDataSource requireDataSource() {
        HikariDataSource currentDataSource = this.dataSource;
        if (currentDataSource == null) {
            throw new DatabaseException("Database is not connected");
        }
        return currentDataSource;
    }

    private int normalizeIsolationLevel(int isolationLevel) {
        switch (isolationLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new DatabaseException("Unsupported transaction isolation level: " + isolationLevel);
            }
        }
        return isolationLevel;
    }

    private void logSlowQuery(long startTime, String sql) {
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        if (durationMs > 500L) {
            this.logger.warn("Slow database query [{}] executed in {} ms", (Object)sql, (Object)durationMs);
        }
    }

    private void shutdownExecutor(ExecutorService executorService) {
        if (executorService == null || executorService.isShutdown()) {
            return;
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void executeSqlStatement(Statement statement, StringBuilder buffer) throws SQLException {
        String sql = buffer.toString().trim();
        if (!sql.isEmpty()) {
            statement.execute(sql);
        }
    }

    private void closeDataSourceQuietly(HikariDataSource source) {
        if (source == null) {
            return;
        }
        try {
            if (!source.isClosed()) {
                source.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to close data source", (Throwable)e);
        }
    }

    public static String getProcedureQuery(String name, String parameters, String body) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new DatabaseException("Invalid procedure name: " + name);
        }
        return "CREATE PROCEDURE IF NOT EXISTS " + name + "(" + parameters + ")\n BEGIN\n    " + body + " \nEND;";
    }

    private static /* synthetic */ void lambda$getAutoIncrement$6(String tableName, PreparedStatement stmt) throws SQLException {
        stmt.setString(1, tableName);
    }

    @FunctionalInterface
    private static interface ConnectionOperation<T> {
        public T execute(Connection var1) throws SQLException;
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger counter = new AtomicInteger();

        private DaemonThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + this.counter.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

