/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.library.utils;

import java.util.List;
import java.util.concurrent.TimeUnit;

public final class AnimationUtils {
    private static final long NANOS_PER_TICK = TimeUnit.SECONDS.toNanos(1L) / 20L;
    private static final long PHASE_WRAP_TICKS = 0x100000L;
    private static final long PHASE_WRAP_MASK = 1048575L;

    private AnimationUtils() {
    }

    private static double bouncePhase(float speed) {
        double ticks = AnimationUtils.currentTickTime();
        return ticks * (double)speed;
    }

    private static double colorPhase(float speed) {
        if (speed == 0.0f) {
            return 0.0;
        }
        double ticks = AnimationUtils.currentTickTime();
        double absSpeed = Math.abs(speed);
        double phase = ticks * absSpeed / 20.0;
        return speed > 0.0f ? phase : -phase;
    }

    public static String animateBounce(String input, float speed) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        if (length == 0) {
            return input;
        }
        double cycle = (double)length * 2.0;
        double index = AnimationUtils.bouncePhase(speed) % cycle;
        if (index < 0.0) {
            index += cycle;
        }
        double distance = index <= (double)length ? (double)length - index : index - (double)length;
        int subLength = (int)Math.round(distance);
        subLength = Math.max(0, Math.min(subLength, length));
        return input.substring(0, subLength);
    }

    public static String animateColor(List<String> colors, String input, float speed) {
        if (colors == null || colors.isEmpty() || input == null) {
            return input;
        }
        int size = colors.size();
        double phase = AnimationUtils.colorPhase(speed);
        long stepIndex = (long)Math.floor(phase);
        int idx = Math.floorMod(stepIndex, size);
        return colors.get(idx) + input;
    }

    public static String animatePerColorCycle(List<String> colors, String input, float speed) {
        if (colors == null || colors.isEmpty() || input == null) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int size = colors.size();
        double basePhase = AnimationUtils.colorPhase(speed);
        for (int i = 0; i < input.length(); ++i) {
            double phase = basePhase + (double)i;
            long stepIndex = (long)Math.floor(phase);
            int colorIndex = Math.floorMod(stepIndex, size);
            String color = colors.get(colorIndex);
            sb.append(color).append(input.charAt(i));
        }
        return sb.toString();
    }

    public static String animateFull(List<String> colors, String input, float speed) {
        String bounced = AnimationUtils.animateBounce(input, speed);
        return AnimationUtils.animatePerColorCycle(colors, bounced, speed);
    }

    private static double currentTickTime() {
        long nanos = System.nanoTime();
        long wholeTicks = nanos / NANOS_PER_TICK;
        long wrappedTicks = wholeTicks & 0xFFFFFL;
        long remainderNanos = nanos % NANOS_PER_TICK;
        double fractional = (double)remainderNanos / (double)NANOS_PER_TICK;
        return (double)wrappedTicks + fractional;
    }
}

